/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Maps;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.domain.Location;
import org.jclouds.elasticstack.ElasticStackAsyncClient;
import org.jclouds.elasticstack.ElasticStackClient;
import org.jclouds.elasticstack.compute.ElasticStackComputeServiceAdapter;
import org.jclouds.elasticstack.compute.functions.ServerInfoToNodeMetadata;
import org.jclouds.elasticstack.compute.functions.WellKnownImageToImage;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.elasticstack.predicates.DriveClaimed;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.json.Json;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.OnlyLocationOrFirstZone;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.util.Strings2;

public class ElasticStackComputeServiceContextModule
extends ComputeServiceAdapterContextModule<ElasticStackClient, ElasticStackAsyncClient, ServerInfo, Hardware, DriveInfo, Location> {
    public ElasticStackComputeServiceContextModule() {
        super(ElasticStackClient.class, ElasticStackAsyncClient.class);
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<ServerInfo, Hardware, DriveInfo, Location>>(){}).to(ElasticStackComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ServerInfo, NodeMetadata>>(){}).to(ServerInfoToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, Image>>(){}).to(IdentityFunction.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Hardware, Hardware>>(){}).to(IdentityFunction.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).to(IdentityFunction.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Device, Volume>>(){}).to(ServerInfoToNodeMetadata.DeviceToVolume.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, String>>(){}).to(ServerInfoToNodeMetadata.GetImageIdFromServer.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<String, Image>>(){}).to(ServerInfoToNodeMetadata.FindImageForId.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<DriveInfo, Image>>(){}).to(WellKnownImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Location>>(){}).to(OnlyLocationOrFirstZone.class);
    }

    @Provides
    @Singleton
    protected Cache<String, DriveInfo> cache(GetDrive getDrive) {
        return CacheBuilder.newBuilder().build((CacheLoader)getDrive);
    }

    @Singleton
    @Provides
    protected Map<String, WellKnownImage> provideImages(Json json, @Provider String providerName) throws IOException {
        List wellKnowns = (List)json.fromJson(Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/" + providerName + "/preinstalled_images.json")), new TypeLiteral<List<WellKnownImage>>(){}.getType());
        return Maps.uniqueIndex((Iterable)wellKnowns, (Function)new Function<WellKnownImage, String>(){

            public String apply(WellKnownImage input) {
                return input.getUuid();
            }
        });
    }

    @Provides
    @Singleton
    protected Predicate<DriveInfo> supplyDriveUnclaimed(DriveClaimed driveClaimed, ComputeServiceConstants.Timeouts timeouts) {
        return new RetryablePredicate(Predicates.not((Predicate)driveClaimed), timeouts.nodeRunning, 1000L, TimeUnit.MILLISECONDS);
    }

    @Singleton
    public static class GetDrive
    extends CacheLoader<String, DriveInfo> {
        private final ElasticStackClient client;

        @Inject
        public GetDrive(ElasticStackClient client) {
            this.client = client;
        }

        public DriveInfo load(String input) {
            return this.client.getDriveInfo(input);
        }
    }
}

