/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.WellKnownImage;

@Singleton
public class WellKnownImageToImage
implements Function<DriveInfo, Image> {
    private final Supplier<Location> locationSupplier;
    private final Map<String, WellKnownImage> preinstalledImages;

    @Inject
    public WellKnownImageToImage(Supplier<Location> locationSupplier, Map<String, WellKnownImage> preinstalledImages) {
        this.locationSupplier = locationSupplier;
        this.preinstalledImages = preinstalledImages;
    }

    public Image apply(DriveInfo drive) {
        WellKnownImage input = this.preinstalledImages.get(drive.getUuid());
        return new ImageBuilder().ids(drive.getUuid()).userMetadata((Map)ImmutableMap.builder().putAll(drive.getUserMetadata()).put((Object)"size", (Object)(input.getSize() + "")).build()).defaultCredentials(new Credentials(input.getLoginUser(), null)).location((Location)this.locationSupplier.get()).name(input.getDescription()).description(drive.getName()).operatingSystem(new OperatingSystem.Builder().family(input.getOsFamily()).version(input.getOsVersion()).name(input.getDescription()).description(drive.getName()).is64Bit(input.is64bit()).build()).version("").build();
    }
}

