/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveMetrics;
import org.jclouds.elasticstack.domain.DriveStatus;
import org.jclouds.javax.annotation.Nullable;

public class DriveInfo
extends Drive {
    protected final DriveStatus status;
    protected final String user;
    protected final Set<String> claimed;
    @Nullable
    protected final String encryptionCipher;
    @Nullable
    protected final String imaging;
    protected final DriveMetrics metrics;

    public DriveInfo(String uuid, String name, long size, ClaimType claimType, Iterable<String> readers, Iterable<String> tags, Map<String, String> userMetadata, DriveStatus status, String user, Set<String> claimed, String encryptionCipher, String imaging, DriveMetrics metrics) {
        super(uuid, name, size, claimType, readers, tags, userMetadata);
        this.status = status;
        this.user = user;
        this.claimed = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(claimed, (Object)"claimed")));
        this.encryptionCipher = encryptionCipher;
        this.imaging = imaging;
        this.metrics = (DriveMetrics)Preconditions.checkNotNull((Object)metrics, (Object)"metrics");
    }

    public DriveStatus getStatus() {
        return this.status;
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getClaimed() {
        return this.claimed;
    }

    @Nullable
    public String getEncryptionCipher() {
        return this.encryptionCipher;
    }

    public String getImaging() {
        return this.imaging;
    }

    public DriveMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.claimed == null ? 0 : ((Object)this.claimed).hashCode());
        result = 31 * result + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = 31 * result + (this.encryptionCipher == null ? 0 : this.encryptionCipher.hashCode());
        result = 31 * result + (this.imaging == null ? 0 : this.imaging.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DriveInfo other = (DriveInfo)obj;
        if (this.claimed == null ? other.claimed != null : !((Object)this.claimed).equals(other.claimed)) {
            return false;
        }
        if (this.metrics == null ? other.metrics != null : !this.metrics.equals(other.metrics)) {
            return false;
        }
        if (this.encryptionCipher == null ? other.encryptionCipher != null : !this.encryptionCipher.equals(other.encryptionCipher)) {
            return false;
        }
        if (this.imaging == null ? other.imaging != null : !this.imaging.equals(other.imaging)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    @Override
    public String toString() {
        return "[size=" + this.size + ", claimType=" + (Object)((Object)this.claimType) + ", readers=" + this.readers + ", uuid=" + this.uuid + ", name=" + this.name + ", tags=" + this.tags + ", userMetadata=" + this.userMetadata + ", status=" + (Object)((Object)this.status) + ", user=" + this.user + ", claimed=" + this.claimed + ", encryptionCipher=" + this.encryptionCipher + ", imaging=" + this.imaging + ", metrics=" + this.metrics + "]";
    }

    public static class Builder
    extends Drive.Builder {
        protected DriveStatus status;
        protected String user;
        protected Set<String> claimed = ImmutableSet.of();
        @Nullable
        protected String encryptionCipher;
        @Nullable
        protected String imaging;
        protected DriveMetrics metrics;

        public Builder status(DriveStatus status) {
            this.status = status;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder claimed(Iterable<String> claimed) {
            this.claimed = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(claimed, (Object)"claimed")));
            return this;
        }

        public Builder imaging(String imaging) {
            this.imaging = imaging;
            return this;
        }

        public Builder metrics(DriveMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder encryptionCipher(String encryptionCipher) {
            this.encryptionCipher = encryptionCipher;
            return this;
        }

        @Override
        public Builder claimType(ClaimType claimType) {
            return (Builder)Builder.class.cast(super.claimType(claimType));
        }

        @Override
        public Builder readers(Iterable<String> readers) {
            return (Builder)Builder.class.cast(super.readers(readers));
        }

        @Override
        public Builder size(long size) {
            return (Builder)Builder.class.cast(super.size(size));
        }

        @Override
        public Builder uuid(String uuid) {
            return (Builder)Builder.class.cast(super.uuid(uuid));
        }

        @Override
        public Builder name(String name) {
            return (Builder)Builder.class.cast(super.name(name));
        }

        @Override
        public Builder tags(Iterable<String> tags) {
            return (Builder)Builder.class.cast(super.tags((Iterable)tags));
        }

        @Override
        public Builder userMetadata(Map<String, String> userMetadata) {
            return (Builder)Builder.class.cast(super.userMetadata((Map)userMetadata));
        }

        public static Builder fromDriveInfo(DriveInfo driveInfo) {
            return ((Builder)((Builder)((Builder)new Builder().uuid(driveInfo.getUuid()).name(driveInfo.getName()).size(driveInfo.getSize()).claimType(driveInfo.getClaimType()).readers(driveInfo.getReaders())).tags(driveInfo.getTags())).userMetadata((Map)driveInfo.getUserMetadata())).status(driveInfo.getStatus()).user(driveInfo.getUser()).claimed(driveInfo.getClaimed()).encryptionCipher(driveInfo.getEncryptionCipher()).imaging(driveInfo.getImaging()).metrics(driveInfo.getMetrics());
        }

        @Override
        public DriveInfo build() {
            return new DriveInfo(this.uuid, this.name, this.size, this.claimType, this.readers, this.tags, this.userMetadata, this.status, this.user, this.claimed, this.encryptionCipher, this.imaging, this.metrics);
        }
    }
}

