/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.NIC;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerMetrics;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.elasticstack.domain.VNC;

@Singleton
public class MapToServerInfo
implements Function<Map<String, String>, ServerInfo> {
    private final Function<Map<String, String>, Map<String, ? extends Device>> mapToDevices;
    private final Function<Map<String, String>, ServerMetrics> mapToMetrics;
    private final Function<Map<String, String>, List<NIC>> mapToNICs;

    @Inject
    public MapToServerInfo(Function<Map<String, String>, Map<String, ? extends Device>> mapToDevices, Function<Map<String, String>, ServerMetrics> mapToMetrics, Function<Map<String, String>, List<NIC>> mapToNICs) {
        this.mapToDevices = mapToDevices;
        this.mapToMetrics = mapToMetrics;
        this.mapToNICs = mapToNICs;
    }

    public ServerInfo apply(Map<String, String> from) {
        if (from.size() == 0) {
            return null;
        }
        ServerInfo.Builder builder = new ServerInfo.Builder();
        builder.name(from.get("name"));
        builder.persistent(Boolean.parseBoolean(from.get("persistent")));
        if (from.containsKey("tags")) {
            builder.tags(Splitter.on((char)' ').split((CharSequence)from.get("tags")));
        }
        if (from.containsKey("status")) {
            builder.status(ServerStatus.fromValue(from.get("status")));
        }
        if (from.containsKey("smp:cores")) {
            builder.smp(Integer.valueOf(from.get("smp:cores")));
        } else if (from.containsKey("smp") && !"auto".equals(from.get("smp"))) {
            builder.smp(Integer.valueOf(from.get("smp")));
        }
        builder.cpu(Integer.parseInt(from.get("cpu")));
        builder.mem(Integer.parseInt(from.get("mem")));
        builder.user(from.get("user"));
        if (from.containsKey("started")) {
            builder.started(new Date(Long.valueOf(from.get("started"))));
        }
        builder.uuid(from.get("server"));
        if (from.containsKey("boot")) {
            builder.bootDeviceIds(Splitter.on((char)' ').split((CharSequence)from.get("boot")));
        }
        builder.vnc(new VNC(from.get("vnc:ip") == null ? "auto" : from.get("vnc:ip"), from.get("vnc:password"), from.containsKey("vnc:tls") && Boolean.valueOf(from.get("vnc:tls")) != false));
        LinkedHashMap metadata = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : from.entrySet()) {
            if (!entry.getKey().startsWith("user:")) continue;
            metadata.put(entry.getKey().substring(entry.getKey().indexOf(58) + 1), entry.getValue());
        }
        builder.userMetadata((Map)metadata);
        builder.nics((Iterable)this.mapToNICs.apply(from));
        builder.devices((Map)this.mapToDevices.apply(from));
        builder.metrics((ServerMetrics)this.mapToMetrics.apply(from));
        return builder.build();
    }
}

