/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.eucalyptus;

import com.google.common.collect.ImmutableSet;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2AsyncClient;
import org.jclouds.ec2.EC2Client;
import org.jclouds.eucalyptus.config.Iso8601SecondsModule;

public class EucalyptusApiMetadata
extends EC2ApiMetadata {
    private static final long serialVersionUID = 3060225665040763827L;

    private static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return EucalyptusApiMetadata.builder().fromApiMetadata((ApiMetadata)this);
    }

    public EucalyptusApiMetadata() {
        this(EucalyptusApiMetadata.builder());
    }

    protected EucalyptusApiMetadata(Builder builder) {
        super((EC2ApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = EC2ApiMetadata.defaultProperties();
        properties.setProperty("jclouds.regions", "eucalyptus");
        properties.setProperty("jclouds.compute.timeout.port-open", "300000");
        return properties;
    }

    public static class Builder
    extends EC2ApiMetadata.Builder {
        protected Builder() {
            super(EC2Client.class, EC2AsyncClient.class);
            this.id("eucalyptus").defaultEndpoint("http://partnercloud.eucalyptus.com:8773/services/Eucalyptus/").name("Eucalyptus (EC2 clone) API").defaultProperties(EucalyptusApiMetadata.defaultProperties()).defaultModules((Set)ImmutableSet.builder().addAll((Iterable)this.defaultModules).add(Iso8601SecondsModule.class).build());
        }

        public EucalyptusApiMetadata build() {
            return new EucalyptusApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

