/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.Image;

@Singleton
public class NovaReviseParsedImage
implements ReviseParsedImage {
    private final Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> imageToOs;

    @Inject
    public NovaReviseParsedImage(Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> imageToOs) {
        this.imageToOs = (Function)Preconditions.checkNotNull(imageToOs, (Object)"imageToOs");
    }

    public void reviseParsedImage(Image from, ImageBuilder builder, OsFamily family, OperatingSystem.Builder osBuilder) {
        org.jclouds.openstack.nova.v2_0.domain.Image image = ((Image.Builder)((Image.Builder)org.jclouds.openstack.nova.v2_0.domain.Image.builder().id(from.getId())).name(from.getName())).build();
        OperatingSystem os = (OperatingSystem)this.imageToOs.apply((Object)image);
        osBuilder.description(os.getDescription());
        osBuilder.family(os.getFamily());
        osBuilder.name(os.getName());
        osBuilder.is64Bit(os.is64Bit());
        osBuilder.version(os.getVersion());
    }
}

