/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.binders.BindAsHostPrefix;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.util.Strings2;

@Singleton
public class BindAsHostPrefixIfConfigured
implements Binder {
    protected final Provider<UriBuilder> uriBuilderProvider;
    protected final BindAsHostPrefix bindAsHostPrefix;
    protected final boolean isVhostStyle;
    protected final String servicePath;

    @Inject
    public BindAsHostPrefixIfConfigured(BindAsHostPrefix bindAsHostPrefix, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.s3.service-path") String servicePath, Provider<UriBuilder> uriBuilderProvider) {
        this.bindAsHostPrefix = bindAsHostPrefix;
        this.isVhostStyle = isVhostStyle;
        this.servicePath = servicePath;
        this.uriBuilderProvider = uriBuilderProvider;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        if (this.isVhostStyle) {
            request = this.bindAsHostPrefix.bindToRequest(request, payload);
            return (R)ModifyRequest.replaceHeader(request, (String)"Host", (String[])new String[]{request.getEndpoint().getHost()});
        }
        UriBuilder builder = ((UriBuilder)this.uriBuilderProvider.get()).uri(request.getEndpoint());
        StringBuilder path = new StringBuilder(Strings2.urlEncode((String)request.getEndpoint().getPath(), (char[])S3AsyncClient.class.getAnnotation(SkipEncoding.class).value()));
        int indexToInsert = 0;
        if (!this.servicePath.equals("/")) {
            indexToInsert = path.indexOf(this.servicePath);
            indexToInsert = indexToInsert == -1 ? 0 : indexToInsert;
            indexToInsert += this.servicePath.length();
        }
        path.insert(indexToInsert, "/" + payload.toString());
        builder.replacePath(path.toString());
        return (R)request.toBuilder().endpoint(builder.buildFromEncodedMap((Map)ImmutableMap.of())).build();
    }
}

