/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.concurrent.Futures;
import org.jclouds.domain.Location;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.blobstore.functions.BucketToResourceList;
import org.jclouds.s3.blobstore.functions.BucketToResourceMetadata;
import org.jclouds.s3.blobstore.functions.ContainerToBucketListOptions;
import org.jclouds.s3.blobstore.functions.ObjectToBlob;
import org.jclouds.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.util.S3Utils;

@Singleton
public class S3AsyncBlobStore
extends BaseAsyncBlobStore {
    private final S3AsyncClient async;
    private final S3Client sync;
    private final BucketToResourceMetadata bucket2ResourceMd;
    private final ContainerToBucketListOptions container2BucketListOptions;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final BucketToResourceList bucket2ResourceList;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ObjectToBlobMetadata object2BlobMd;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;
    private final LoadingCache<String, AccessControlList> bucketAcls;

    @Inject
    protected S3AsyncBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ExecutorService service, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, S3AsyncClient async, S3Client sync, BucketToResourceMetadata bucket2ResourceMd, ContainerToBucketListOptions container2BucketListOptions, BucketToResourceList bucket2ResourceList, ObjectToBlob object2Blob, BlobToHttpGetOptions blob2ObjectGetOptions, BlobToObject blob2Object, ObjectToBlobMetadata object2BlobMd, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, LoadingCache<String, AccessControlList> bucketAcls) {
        super(context, blobUtils, service, defaultLocation, locations);
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.async = (S3AsyncClient)Preconditions.checkNotNull((Object)async, (Object)"async");
        this.sync = (S3Client)Preconditions.checkNotNull((Object)sync, (Object)"sync");
        this.bucket2ResourceMd = (BucketToResourceMetadata)Preconditions.checkNotNull((Object)bucket2ResourceMd, (Object)"bucket2ResourceMd");
        this.container2BucketListOptions = (ContainerToBucketListOptions)Preconditions.checkNotNull((Object)container2BucketListOptions, (Object)"container2BucketListOptions");
        this.bucket2ResourceList = (BucketToResourceList)Preconditions.checkNotNull((Object)bucket2ResourceList, (Object)"bucket2ResourceList");
        this.object2Blob = (ObjectToBlob)Preconditions.checkNotNull((Object)object2Blob, (Object)"object2Blob");
        this.blob2Object = (BlobToObject)Preconditions.checkNotNull((Object)blob2Object, (Object)"blob2Object");
        this.object2BlobMd = (ObjectToBlobMetadata)Preconditions.checkNotNull((Object)object2BlobMd, (Object)"object2BlobMd");
        this.fetchBlobMetadataProvider = (Provider)Preconditions.checkNotNull(fetchBlobMetadataProvider, (Object)"fetchBlobMetadataProvider");
        this.bucketAcls = (LoadingCache)Preconditions.checkNotNull(bucketAcls, (Object)"bucketAcls");
    }

    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        return Futures.compose(this.async.listOwnedBuckets(), (Function)new Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>>(){

            public PageSet<? extends StorageMetadata> apply(Set<BucketMetadata> from) {
                return new PageSetImpl(Iterables.transform(from, (Function)S3AsyncBlobStore.this.bucket2ResourceMd), null);
            }
        }, (ExecutorService)this.service);
    }

    public ListenableFuture<Boolean> containerExists(String container) {
        return this.async.bucketExists(container);
    }

    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container) {
        return this.createContainerInLocation(location, container, (CreateContainerOptions)CreateContainerOptions.NONE);
    }

    public ListenableFuture<PageSet<? extends StorageMetadata>> list(String container, ListContainerOptions options) {
        ListBucketOptions httpOptions = this.container2BucketListOptions.apply(options);
        ListenableFuture<ListBucketResponse> returnVal = this.async.listBucket(container, httpOptions);
        ListenableFuture list = Futures.compose(returnVal, (Function)this.bucket2ResourceList, (ExecutorService)this.service);
        return options.isDetailed() ? Futures.compose((Future)list, (Function)((FetchBlobMetadata)this.fetchBlobMetadataProvider.get()).setContainerName(container), (ExecutorService)this.service) : list;
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        return S3Utils.deleteAndVerifyContainerGone(this.sync, container);
    }

    public ListenableFuture<Boolean> blobExists(String container, String key) {
        return this.async.objectExists(container, key);
    }

    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        return Futures.compose(this.async.headObject(container, key), (Function)new Function<ObjectMetadata, BlobMetadata>(){

            public BlobMetadata apply(ObjectMetadata from) {
                return S3AsyncBlobStore.this.object2BlobMd.apply(from);
            }
        }, (ExecutorService)this.service);
    }

    public ListenableFuture<Blob> getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(options);
        return Futures.compose(this.async.getObject(container, key, httpOptions), (Function)this.object2Blob, (ExecutorService)this.service);
    }

    public ListenableFuture<String> putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, (PutOptions)PutOptions.NONE);
    }

    public ListenableFuture<String> putBlob(String container, Blob blob, PutOptions overrides) {
        PutObjectOptions options = new PutObjectOptions();
        try {
            AccessControlList acl = (AccessControlList)this.bucketAcls.getUnchecked((Object)container);
            if (acl.hasPermission(AccessControlList.GroupGranteeURI.ALL_USERS, "READ")) {
                options.withAcl(CannedAccessPolicy.PUBLIC_READ);
            }
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            // empty catch block
        }
        return this.async.putObject(container, this.blob2Object.apply(blob), options);
    }

    public ListenableFuture<Void> removeBlob(String container, String key) {
        return this.async.deleteObject(container, key);
    }

    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        PutBucketOptions putBucketOptions = new PutBucketOptions();
        if (options.isPublicRead()) {
            putBucketOptions.withBucketAcl(CannedAccessPolicy.PUBLIC_READ);
        }
        location = location != null ? location : (Location)this.defaultLocation.get();
        return this.async.putBucketInRegion(location.getId(), container, putBucketOptions);
    }
}

