/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.config;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.config.BlobStoreMapModule;
import org.jclouds.blobstore.internal.BlobStoreContextImpl;
import org.jclouds.domain.Location;
import org.jclouds.s3.S3AsyncClient;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.S3AsyncBlobStore;
import org.jclouds.s3.blobstore.S3BlobRequestSigner;
import org.jclouds.s3.blobstore.S3BlobStore;
import org.jclouds.s3.blobstore.functions.LocationFromBucketLocation;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketMetadata;

public class S3BlobStoreContextModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new BlobStoreMapModule());
        this.bind(ConsistencyModel.class).toInstance((Object)ConsistencyModel.EVENTUAL);
        this.bind(AsyncBlobStore.class).to(S3AsyncBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStore.class).to(S3BlobStore.class).in(Scopes.SINGLETON);
        this.bindContext();
        this.bind(BlobRequestSigner.class).to(S3BlobRequestSigner.class);
        this.bindBucketLocationStrategy();
    }

    protected void bindContext() {
        this.bind(BlobStoreContext.class).to((TypeLiteral)new TypeLiteral<BlobStoreContextImpl<S3Client, S3AsyncClient>>(){}).in(Scopes.SINGLETON);
    }

    protected void bindBucketLocationStrategy() {
        this.bind((TypeLiteral)new TypeLiteral<Function<BucketMetadata, Location>>(){}).to(LocationFromBucketLocation.class);
    }

    @Provides
    @Singleton
    protected LoadingCache<String, AccessControlList> bucketAcls(final S3Client client) {
        return CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, AccessControlList>(){

            public AccessControlList load(String bucketName) {
                return client.getBucketACL(bucketName);
            }

            public String toString() {
                return "getBucketAcl()";
            }
        });
    }
}

