/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.handlers;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.handlers.ParseAWSErrorFromXmlContent;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class ParseS3ErrorFromXmlContent
extends ParseAWSErrorFromXmlContent {
    private final String servicePath;
    private final boolean isVhostStyle;

    @Inject
    ParseS3ErrorFromXmlContent(AWSUtils utils, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.s3.service-path") String servicePath) {
        super(utils);
        this.servicePath = servicePath;
        this.isVhostStyle = isVhostStyle;
    }

    protected Exception refineException(HttpCommand command, HttpResponse response, Exception exception, AWSError error, String message) {
        switch (response.getStatusCode()) {
            case 404: {
                if (!command.getCurrentRequest().getMethod().equals("DELETE")) {
                    exception = new ResourceNotFoundException(message, exception);
                    if (this.isVhostStyle) {
                        String container = command.getCurrentRequest().getEndpoint().getHost();
                        String key = command.getCurrentRequest().getEndpoint().getPath();
                        exception = key == null || key.equals("/") ? new ContainerNotFoundException(container, message) : new KeyNotFoundException(container, key, message);
                    } else if (command.getCurrentRequest().getEndpoint().getPath().indexOf(this.servicePath + "/") == 0) {
                        String path = command.getCurrentRequest().getEndpoint().getPath().substring(this.servicePath.length());
                        ArrayList parts = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Splitter.on((char)'/').split((CharSequence)path), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)""))));
                        if (parts.size() == 1) {
                            exception = new ContainerNotFoundException((String)parts.get(0), message);
                        } else if (parts.size() > 1) {
                            exception = new KeyNotFoundException((String)parts.remove(0), Joiner.on((char)'/').join((Iterable)parts), message);
                        }
                    }
                }
                return exception;
            }
        }
        return super.refineException(command, response, (Exception)exception, error, message);
    }
}

