/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.config;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.config.FormSigningRestClientModule;
import org.jclouds.http.RequiresHttp;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.location.config.ProvideZonesViaProperties;
import org.jclouds.rest.ConfiguresRestClient;

@ConfiguresRestClient
@RequiresHttp
public class WithZonesFormSigningRestClientModule<S, A>
extends FormSigningRestClientModule<S, A> {
    public WithZonesFormSigningRestClientModule(Class<S> syncClientType, Class<A> asyncClientType, Map<Class<?>, Class<?>> delegates) {
        super(syncClientType, asyncClientType, delegates);
    }

    public WithZonesFormSigningRestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        super(syncClientType, asyncClientType);
    }

    protected void bindZonesToProvider() {
        this.bindZonesToProvider(ProvideZonesViaProperties.class);
    }

    protected void bindZonesToProvider(Class<? extends Provider<Map<String, String>>> providerClass) {
        this.bind((TypeLiteral)new TypeLiteral<Map<String, String>>(){}).annotatedWith(Zone.class).toProvider(providerClass).in(Scopes.SINGLETON);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bindZonesToProvider();
    }

    @Provides
    @Singleton
    @Zone
    protected Map<String, URI> provideZones(final @Region Map<String, URI> regionToEndpoint, @Zone Map<String, String> availabilityZoneToRegion) {
        return Maps.transformValues(availabilityZoneToRegion, (Function)new Function<String, URI>(){

            public URI apply(String from) {
                return (URI)regionToEndpoint.get(from);
            }
        });
    }
}

