/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.concurrent.RetryOnTimeOutExceptionFunction;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.location.Provider;
import org.jclouds.openstack.domain.AuthenticationResponse;
import org.jclouds.openstack.functions.URIFromAuthenticationResponseForService;
import org.jclouds.openstack.handlers.RetryOnRenew;
import org.jclouds.openstack.internal.Authentication;
import org.jclouds.openstack.internal.OpenStackAuthAsyncClient;
import org.jclouds.openstack.internal.OpenStackAuthClient;
import org.jclouds.rest.config.BinderUtils;

public class OpenStackAuthenticationModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<Credentials, AuthenticationResponse>>(){}).to(GetAuthenticationResponse.class);
        BinderUtils.bindClientAndAsyncClient((Binder)this.binder(), OpenStackAuthClient.class, OpenStackAuthAsyncClient.class);
        this.install(new FactoryModuleBuilder().build(URIFromAuthenticationResponseForService.Factory.class));
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideAuthenticationTokenCache(final Supplier<AuthenticationResponse> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            public String get() {
                return ((AuthenticationResponse)supplier.get()).getAuthToken();
            }
        };
    }

    @Provides
    @Singleton
    public LoadingCache<Credentials, AuthenticationResponse> provideAuthenticationResponseCache(Function<Credentials, AuthenticationResponse> getAuthenticationResponse) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build(CacheLoader.from(getAuthenticationResponse));
    }

    @Provides
    @Singleton
    protected Supplier<AuthenticationResponse> provideAuthenticationResponseSupplier(final LoadingCache<Credentials, AuthenticationResponse> cache, final @Provider Credentials creds) {
        return new Supplier<AuthenticationResponse>(){

            public AuthenticationResponse get() {
                return (AuthenticationResponse)cache.getUnchecked((Object)creds);
            }
        };
    }

    @Provides
    @Singleton
    @TimeStamp
    protected Supplier<Date> provideCacheBusterDate() {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Date>(){

            public Date get() {
                return new Date();
            }
        }, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Singleton
    public static class GetAuthenticationResponse
    extends RetryOnTimeOutExceptionFunction<Credentials, AuthenticationResponse> {
        @Inject
        public GetAuthenticationResponse(final OpenStackAuthClient client) {
            super((Function)new Function<Credentials, AuthenticationResponse>(){

                public AuthenticationResponse apply(Credentials input) {
                    return client.authenticate(input.identity, input.credential);
                }

                public String toString() {
                    return "authenticate()";
                }
            });
        }
    }
}

