/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8;

import java.util.Properties;
import org.jclouds.PropertiesBuilder;
import org.jclouds.trmk.vcloud_0_8.domain.FenceMode;

public class TerremarkVCloudPropertiesBuilder
extends PropertiesBuilder {
    protected Properties defaultProperties() {
        Properties properties = super.defaultProperties();
        properties.setProperty("jclouds.api-version", "0.8");
        properties.setProperty("jclouds.vcloud.version.schema", "0.8");
        properties.setProperty("jclouds.session-interval", "480");
        properties.setProperty("jclouds.vcloud.xml.schema", "http://vcloud.safesecureweb.com/ns/vcloud.xsd");
        properties.setProperty("jclouds.dns_name_length_min", "1");
        properties.setProperty("jclouds.dns_name_length_max", "15");
        properties.setProperty("jclouds.vcloud.timeout.task-complete", "420000");
        return properties;
    }

    public TerremarkVCloudPropertiesBuilder(Properties properties) {
        super(properties);
    }

    void setExtensions() {
        if (this.properties.getProperty("jclouds.terremark.extension.ns") == null) {
            this.properties.setProperty("jclouds.terremark.extension.ns", String.format("urn:tmrk:%s-%s", this.properties.getProperty("jclouds.terremark.extension.name"), this.properties.getProperty("jclouds.terremark.extension.version")));
        }
    }

    protected void setNs() {
        if (this.properties.getProperty("jclouds.vcloud.xml.ns") == null) {
            this.properties.setProperty("jclouds.vcloud.xml.ns", "http://www.vmware.com/vcloud/v" + this.properties.getProperty("jclouds.vcloud.version.schema"));
        }
    }

    protected void setFenceMode() {
        if (this.properties.getProperty("jclouds.vcloud.defaults.fencemode") == null) {
            if (this.properties.getProperty("jclouds.vcloud.version.schema").startsWith("0.8")) {
                this.properties.setProperty("jclouds.vcloud.defaults.fencemode", "allowInOut");
            } else {
                this.properties.setProperty("jclouds.vcloud.defaults.fencemode", FenceMode.ALLOW_IN_OUT.toString());
            }
        }
    }

    public TerremarkVCloudPropertiesBuilder withApiVersion(String version) {
        this.properties.setProperty("jclouds.api-version", "0.8");
        return this;
    }

    public TerremarkVCloudPropertiesBuilder withSchemaVersion(String version) {
        this.properties.setProperty("jclouds.vcloud.version.schema", "0.8");
        return this;
    }

    public Properties build() {
        this.setNs();
        this.setFenceMode();
        this.setExtensions();
        return super.build();
    }
}

