/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.RestContextImpl;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.compute.TerremarkVCloudComputeService;
import org.jclouds.trmk.vcloud_0_8.compute.config.TerremarkBindComputeStrategiesByClass;
import org.jclouds.trmk.vcloud_0_8.compute.config.TerremarkBindComputeSuppliersByClass;
import org.jclouds.trmk.vcloud_0_8.compute.domain.KeyPairCredentials;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.ImagesInVCloudExpressOrg;
import org.jclouds.trmk.vcloud_0_8.compute.functions.NodeMetadataToOrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.ParseOsFromVAppTemplateName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.VAppToNodeMetadata;
import org.jclouds.trmk.vcloud_0_8.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.ParseVAppTemplateDescriptionToGetDefaultLoginCredentials;
import org.jclouds.trmk.vcloud_0_8.domain.Org;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;

public class TerremarkVCloudComputeServiceContextModule
extends BaseComputeServiceContextModule {
    @VisibleForTesting
    public static final Map<Status, NodeState> VAPPSTATUS_TO_NODESTATE = ImmutableMap.builder().put((Object)Status.OFF, (Object)NodeState.SUSPENDED).put((Object)Status.ON, (Object)NodeState.RUNNING).put((Object)Status.RESOLVED, (Object)NodeState.PENDING).put((Object)Status.UNRECOGNIZED, (Object)NodeState.UNRECOGNIZED).put((Object)Status.DEPLOYED, (Object)NodeState.PENDING).put((Object)Status.SUSPENDED, (Object)NodeState.SUSPENDED).put((Object)Status.UNRESOLVED, (Object)NodeState.PENDING).build();

    @Singleton
    @Provides
    protected Map<Status, NodeState> provideVAppStatusToNodeState() {
        return VAPPSTATUS_TO_NODESTATE;
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<Function<NodeMetadata, OrgAndName>>(){}).to((TypeLiteral)new TypeLiteral<NodeMetadataToOrgAndName>(){});
        this.bind(TemplateOptions.class).to(TerremarkVCloudTemplateOptions.class);
        this.bind(ComputeService.class).to(TerremarkVCloudComputeService.class);
        this.bind(PopulateDefaultLoginCredentialsForImageStrategy.class).to(ParseVAppTemplateDescriptionToGetDefaultLoginCredentials.class);
        this.bind(SecureRandom.class).toInstance((Object)new SecureRandom());
        this.install((Module)new TerremarkBindComputeStrategiesByClass());
        this.install((Module)new TerremarkBindComputeSuppliersByClass());
        this.bindVAppConverter();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceContext>(){}).to((TypeLiteral)new TypeLiteral<ComputeServiceContextImpl<TerremarkVCloudClient, TerremarkVCloudAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<RestContext<TerremarkVCloudClient, TerremarkVCloudAsyncClient>>(){}).to((TypeLiteral)new TypeLiteral<RestContextImpl<TerremarkVCloudClient, TerremarkVCloudAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<Function<Org, Iterable<? extends Image>>>(){}).to((TypeLiteral)new TypeLiteral<ImagesInVCloudExpressOrg>(){});
        this.bind((TypeLiteral)new TypeLiteral<Function<String, OperatingSystem>>(){}).to(ParseOsFromVAppTemplateName.class);
    }

    protected void bindVAppConverter() {
        this.bind((TypeLiteral)new TypeLiteral<Function<VApp, NodeMetadata>>(){}).to(VAppToNodeMetadata.class);
    }

    @Provides
    @Singleton
    Supplier<String> provideSuffix(final SecureRandom random) {
        return new Supplier<String>(){

            public String get() {
                return random.nextInt(4096) + "";
            }
        };
    }

    @Provides
    @Singleton
    ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap() {
        return new ConcurrentHashMap<OrgAndName, KeyPairCredentials>();
    }

    @Named(value="PASSWORD")
    @Provides
    String providePassword(SecureRandom random) {
        return random.nextLong() + "";
    }
}

