/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.compute.domain.KeyPairCredentials;
import org.jclouds.trmk.vcloud_0_8.compute.domain.OrgAndName;
import org.jclouds.trmk.vcloud_0_8.compute.functions.CreateUniqueKeyPair;
import org.jclouds.trmk.vcloud_0_8.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.domain.KeyPair;

@Singleton
public class CreateNewKeyPairUnlessUserSpecifiedOtherwise {
    final ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap;
    @VisibleForTesting
    final CreateUniqueKeyPair createUniqueKeyPair;

    @Inject
    CreateNewKeyPairUnlessUserSpecifiedOtherwise(ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap, CreateUniqueKeyPair createUniqueKeyPair) {
        this.credentialsMap = credentialsMap;
        this.createUniqueKeyPair = createUniqueKeyPair;
    }

    @VisibleForTesting
    public void execute(URI org, String tag, String identity, TerremarkVCloudTemplateOptions options) {
        String sshKeyFingerprint = options.getSshKeyFingerprint();
        boolean shouldAutomaticallyCreateKeyPair = options.shouldAutomaticallyCreateKeyPair();
        if (sshKeyFingerprint == null && shouldAutomaticallyCreateKeyPair) {
            OrgAndName orgAndName = new OrgAndName(org, tag);
            if (this.credentialsMap.containsKey(orgAndName)) {
                options.sshKeyFingerprint(((KeyPairCredentials)((Object)this.credentialsMap.get(orgAndName))).getKeyPair().getFingerPrint());
            } else {
                KeyPair keyPair = this.createUniqueKeyPair.apply(orgAndName);
                this.credentialsMap.put(orgAndName, new KeyPairCredentials(identity, keyPair));
                options.sshKeyFingerprint(keyPair.getFingerPrint());
            }
        }
    }
}

