/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.domain.Credentials;
import org.jclouds.trmk.vcloud_0_8.compute.TerremarkVCloudComputeClient;
import org.jclouds.trmk.vcloud_0_8.compute.functions.TemplateToInstantiateOptions;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;

@Singleton
public class StartVAppWithGroupEncodedIntoName
implements CreateNodeWithGroupEncodedIntoName {
    protected final TerremarkVCloudComputeClient computeClient;
    protected final TemplateToInstantiateOptions getOptions;
    protected final Function<VApp, NodeMetadata> vAppToNodeMetadata;
    private final Map<String, Credentials> credentialStore;

    @Inject
    protected StartVAppWithGroupEncodedIntoName(TerremarkVCloudComputeClient computeClient, Function<VApp, NodeMetadata> vAppToNodeMetadata, TemplateToInstantiateOptions getOptions, Map<String, Credentials> credentialStore) {
        this.computeClient = computeClient;
        this.vAppToNodeMetadata = vAppToNodeMetadata;
        this.getOptions = (TemplateToInstantiateOptions)Preconditions.checkNotNull((Object)getOptions, (Object)"getOptions");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
    }

    public NodeMetadata createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        InstantiateVAppTemplateOptions options = this.getOptions.apply(template);
        VApp vApp = this.computeClient.start(URI.create(template.getLocation().getId()), URI.create(template.getImage().getId()), name, options, template.getOptions().getInboundPorts());
        NodeMetadata node = (NodeMetadata)this.vAppToNodeMetadata.apply((Object)vApp);
        NodeMetadataBuilder builder = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node);
        if (template.getImage().getAdminPassword() != null) {
            builder.adminPassword(template.getImage().getAdminPassword());
            this.credentialStore.put("node#" + node.getId() + "#adminPassword", new Credentials("root", template.getImage().getAdminPassword()));
        }
        return builder.build();
    }
}

