/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class BindAddInternetServiceToXmlPayload
implements MapBinder {
    @Inject
    @Named(value="CreateInternetService")
    private String xmlTemplate;
    @Inject
    private BindToStringPayload stringBinder;
    @Inject
    @Named(value="jclouds.terremark.extension.ns")
    private String ns;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        String name = (String)Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name parameter not present");
        String protocol = (String)Preconditions.checkNotNull((Object)postParams.get("protocol"), (Object)"protocol parameter not present");
        String port = (String)Preconditions.checkNotNull((Object)postParams.get("port"), (Object)"port parameter not present");
        String enabled = (String)Preconditions.checkNotNull((Object)postParams.get("enabled"), (Object)"enabled parameter not present");
        String description = postParams.get("description");
        String payload = Strings2.replaceTokens((String)this.xmlTemplate, (Map)ImmutableMap.of((Object)"name", (Object)name, (Object)"protocol", (Object)protocol, (Object)"port", (Object)port, (Object)"enabled", (Object)enabled, (Object)"ns", (Object)this.ns));
        try {
            payload = Strings2.replaceAll((String)payload, (Pattern)((Pattern)Patterns.TOKEN_TO_PATTERN.get((Object)"description")), (String)(description == null ? "" : String.format("\n\t<Description>%s</Description>", description)));
            payload = Strings2.replaceAll((String)payload, (Pattern)((Pattern)Patterns.TOKEN_TO_PATTERN.get((Object)"monitor")), (String)this.getMonitorString(postParams));
        }
        catch (ExecutionException e) {
            Throwables.propagate((Throwable)e);
        }
        return (R)this.stringBinder.bindToRequest(request, (Object)payload);
    }

    private String getMonitorString(Map<String, String> postParams) {
        String monitor = postParams.get("monitor");
        if (monitor == null || "true".equalsIgnoreCase(monitor)) {
            return "";
        }
        return "\n\t<Monitor><MonitorType>Disabled</MonitorType></Monitor>";
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("CreateInternetService needs parameters");
    }
}

