/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cim.OSType;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.trmk.vcloud_0_8.compute.TerremarkVCloudComputeClient;
import org.jclouds.trmk.vcloud_0_8.compute.functions.FindLocationForResource;
import org.jclouds.trmk.vcloud_0_8.compute.functions.HardwareForVCloudExpressVApp;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;

@Singleton
public class VAppToNodeMetadata
implements Function<VApp, NodeMetadata> {
    protected final TerremarkVCloudComputeClient computeClient;
    protected final Map<String, Credentials> credentialStore;
    protected final Supplier<Set<? extends Image>> images;
    protected final FindLocationForResource findLocationForResourceInVDC;
    protected final HardwareForVCloudExpressVApp hardwareForVCloudExpressVApp;
    protected final Map<Status, NodeState> vAppStatusToNodeState;

    @Inject
    protected VAppToNodeMetadata(TerremarkVCloudComputeClient computeClient, Map<String, Credentials> credentialStore, Map<Status, NodeState> vAppStatusToNodeState, HardwareForVCloudExpressVApp hardwareForVCloudExpressVApp, FindLocationForResource findLocationForResourceInVDC, @Memoized Supplier<Set<? extends Image>> images) {
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.hardwareForVCloudExpressVApp = (HardwareForVCloudExpressVApp)Preconditions.checkNotNull((Object)hardwareForVCloudExpressVApp, (Object)"hardwareForVCloudExpressVApp");
        this.findLocationForResourceInVDC = (FindLocationForResource)Preconditions.checkNotNull((Object)findLocationForResourceInVDC, (Object)"findLocationForResourceInVDC");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.computeClient = (TerremarkVCloudComputeClient)Preconditions.checkNotNull((Object)computeClient, (Object)"computeClient");
        this.vAppStatusToNodeState = (Map)Preconditions.checkNotNull(vAppStatusToNodeState, (Object)"vAppStatusToNodeState");
    }

    public NodeMetadata apply(VApp from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        builder.hostname(from.getName());
        Location vdcLocation = this.findLocationForResourceInVDC.apply(from.getVDC());
        builder.location(vdcLocation);
        if (from.getOsType() != null && OSType.fromValue((int)from.getOsType()) != OSType.UNRECOGNIZED) {
            builder.operatingSystem((OperatingSystem)new CIMOperatingSystem(OSType.fromValue((int)from.getOsType()), "", null, from.getOperatingSystemDescription()));
        } else if (from.getOperatingSystemDescription() != null) {
            OperatingSystem.Builder osBuilder = new OperatingSystem.Builder();
            if (from.getOsType() != null) {
                osBuilder.name(from.getOsType() + "");
            }
            osBuilder.family(ComputeServiceUtils.parseOsFamilyOrUnrecognized((String)from.getOperatingSystemDescription()));
            osBuilder.version("");
            osBuilder.is64Bit(from.getOperatingSystemDescription().indexOf("64") != -1);
            osBuilder.description(from.getOperatingSystemDescription());
            builder.operatingSystem(osBuilder.build());
        }
        builder.hardware(this.hardwareForVCloudExpressVApp.apply(from));
        builder.state(this.vAppStatusToNodeState.get((Object)from.getStatus()));
        builder.publicAddresses(this.computeClient.getPublicAddresses(from.getHref()));
        builder.privateAddresses(this.computeClient.getPrivateAddresses(from.getHref()));
        String group = ComputeServiceUtils.parseGroupFromName((String)from.getName());
        builder.group(group);
        builder.credentials(LoginCredentials.fromCredentials((Credentials)this.credentialStore.get("node#" + from.getHref().toASCIIString())));
        return builder.build();
    }
}

