/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.options;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.io.Payload;
import org.jclouds.util.Preconditions2;

public class TerremarkVCloudTemplateOptions
extends TemplateOptions
implements Cloneable {
    private String keyPair = null;
    private boolean noKeyPair;
    public static final TerremarkVCloudTemplateOptions NONE = new TerremarkVCloudTemplateOptions();

    public TerremarkVCloudTemplateOptions clone() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof TerremarkVCloudTemplateOptions) {
            TerremarkVCloudTemplateOptions eTo = (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(to);
            if (this.noKeyPair) {
                eTo.noKeyPair();
            }
            if (this.keyPair != null) {
                eTo.keyPair = this.keyPair;
            }
        }
    }

    public TerremarkVCloudTemplateOptions sshKeyFingerprint(String keyPair) {
        Preconditions.checkNotNull((Object)keyPair, (Object)"use noKeyPair option to request boot without a keypair");
        Preconditions.checkState((!this.noKeyPair ? 1 : 0) != 0, (Object)"you cannot specify both options keyPair and noKeyPair");
        Preconditions2.checkNotEmpty((String)keyPair, (String)"keypair must be non-empty");
        this.keyPair = keyPair;
        return this;
    }

    public TerremarkVCloudTemplateOptions noKeyPair() {
        Preconditions.checkState((this.keyPair == null ? 1 : 0) != 0, (Object)"you cannot specify both options keyPair and noKeyPair");
        this.noKeyPair = true;
        return this;
    }

    public TerremarkVCloudTemplateOptions blockOnPort(int port, int seconds) {
        return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public TerremarkVCloudTemplateOptions inboundPorts(int ... ports) {
        return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public TerremarkVCloudTemplateOptions authorizePublicKey(String publicKey) {
        return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public TerremarkVCloudTemplateOptions installPrivateKey(String privateKey) {
        return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Deprecated
    public TerremarkVCloudTemplateOptions runScript(Payload script) {
        return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(super.runScript(script));
    }

    public TerremarkVCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public TerremarkVCloudTemplateOptions userMetadata(String key, String value) {
        return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public String getSshKeyFingerprint() {
        return this.keyPair;
    }

    public boolean shouldAutomaticallyCreateKeyPair() {
        return !this.noKeyPair;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keyPair == null ? 0 : this.keyPair.hashCode());
        result = 31 * result + (this.noKeyPair ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerremarkVCloudTemplateOptions other = (TerremarkVCloudTemplateOptions)obj;
        if (this.keyPair == null ? other.keyPair != null : !this.keyPair.equals(other.keyPair)) {
            return false;
        }
        return this.noKeyPair == other.noKeyPair;
    }

    public String toString() {
        return "TerremarkVCloudTemplateOptions [keyPair=" + this.keyPair + ", noKeyPair=" + this.noKeyPair + ", inboundPorts=" + this.inboundPorts + ", privateKey=" + (this.privateKey != null) + ", publicKey=" + (this.publicKey != null) + ", runScript=" + (this.script != null) + ", port:seconds=" + this.port + ":" + this.seconds + ", userMetadata: " + this.userMetadata + "]";
    }

    public static class Builder {
        public static TerremarkVCloudTemplateOptions sshKeyFingerprint(String keyPair) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.sshKeyFingerprint(keyPair));
        }

        public static TerremarkVCloudTemplateOptions noKeyPair() {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.noKeyPair());
        }

        public static TerremarkVCloudTemplateOptions inboundPorts(int ... ports) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static TerremarkVCloudTemplateOptions blockOnPort(int port, int seconds) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static TerremarkVCloudTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.blockUntilRunning(blockUntilRunning));
        }

        public static TerremarkVCloudTemplateOptions installPrivateKey(String rsaKey) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static TerremarkVCloudTemplateOptions authorizePublicKey(String rsaKey) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static TerremarkVCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static TerremarkVCloudTemplateOptions userMetadata(String key, String value) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)TerremarkVCloudTemplateOptions.class.cast(options.userMetadata(key, value));
        }
    }
}

