/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.PrioritizeCredentialsFromTemplate;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.trmk.vcloud_0_8.compute.TerremarkVCloudComputeClient;
import org.jclouds.trmk.vcloud_0_8.compute.functions.TemplateToInstantiateOptions;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;

@Singleton
public class StartVAppWithGroupEncodedIntoName
implements CreateNodeWithGroupEncodedIntoName {
    protected final TerremarkVCloudComputeClient computeClient;
    protected final TemplateToInstantiateOptions getOptions;
    protected final Function<VApp, NodeMetadata> vAppToNodeMetadata;
    protected final Map<String, Credentials> credentialStore;
    protected final PrioritizeCredentialsFromTemplate prioritizeCredentialsFromTemplate;

    @Inject
    protected StartVAppWithGroupEncodedIntoName(TerremarkVCloudComputeClient computeClient, Function<VApp, NodeMetadata> vAppToNodeMetadata, TemplateToInstantiateOptions getOptions, Map<String, Credentials> credentialStore, PrioritizeCredentialsFromTemplate prioritizeCredentialsFromTemplate) {
        this.computeClient = computeClient;
        this.vAppToNodeMetadata = vAppToNodeMetadata;
        this.getOptions = (TemplateToInstantiateOptions)Preconditions.checkNotNull((Object)getOptions, (Object)"getOptions");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.prioritizeCredentialsFromTemplate = (PrioritizeCredentialsFromTemplate)Preconditions.checkNotNull((Object)prioritizeCredentialsFromTemplate, (Object)"prioritizeCredentialsFromTemplate");
    }

    public NodeMetadata createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        LoginCredentials creds;
        InstantiateVAppTemplateOptions options = this.getOptions.apply(template);
        ComputeServiceAdapter.NodeAndInitialCredentials<VApp> from = this.computeClient.startAndReturnCredentials(URI.create(template.getLocation().getId()), URI.create(template.getImage().getId()), name, options, template.getOptions().getInboundPorts());
        LoginCredentials fromNode = from.getCredentials();
        if (this.credentialStore.containsKey("group#" + group)) {
            LoginCredentials loginCredentials = fromNode = fromNode == null ? LoginCredentials.fromCredentials((Credentials)this.credentialStore.get("group#" + group)) : fromNode.toBuilder().privateKey(this.credentialStore.get((Object)new StringBuilder().append((String)"group#").append((String)group).toString()).credential).build();
        }
        if ((creds = this.prioritizeCredentialsFromTemplate.apply(template, fromNode)) != null) {
            this.credentialStore.put("node#" + from.getNodeId(), (Credentials)creds);
        }
        return (NodeMetadata)this.vAppToNodeMetadata.apply(from.getNode());
    }
}

