/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Preconditions;

public enum Status {
    UNRESOLVED,
    RESOLVED,
    SUSPENDED,
    ON,
    OFF,
    UNRECOGNIZED,
    DEPLOYED;


    public String value() {
        switch (this) {
            case UNRESOLVED: {
                return "0";
            }
            case RESOLVED: {
                return "1";
            }
            case OFF: {
                return "2";
            }
            case SUSPENDED: {
                return "3";
            }
            case ON: {
                return "4";
            }
        }
        return "7";
    }

    public static Status fromValue(String status) {
        try {
            return Status.fromValue(Integer.parseInt((String)Preconditions.checkNotNull((Object)status, (Object)"status")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }

    public static Status fromValue(int v) {
        switch (v) {
            case 0: {
                return UNRESOLVED;
            }
            case 1: {
                return RESOLVED;
            }
            case 2: {
                return OFF;
            }
            case 3: {
                return SUSPENDED;
            }
            case 4: {
                return ON;
            }
            case 7: {
                return UNRECOGNIZED;
            }
        }
        return UNRECOGNIZED;
    }
}

