/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudAsyncClient;
import org.jclouds.trmk.vcloud_0_8.domain.Org;

@Singleton
public class OrgsForNames
implements Function<Iterable<String>, Iterable<? extends Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final TerremarkVCloudAsyncClient aclient;
    private final ExecutorService executor;

    @Inject
    OrgsForNames(TerremarkVCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.aclient = aclient;
        this.executor = executor;
    }

    public Iterable<? extends Org> apply(Iterable<String> from) {
        return FutureIterables.transformParallel(from, (Function)new Function<String, Future<Org>>(){

            public Future<Org> apply(String from) {
                return OrgsForNames.this.aclient.findOrgNamed(from);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)"organizations for names");
    }
}

