/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.VCloudToken;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudSession;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.xml.OrgListHandler;

@Singleton
public class ParseLoginResponseFromHeaders
implements Function<HttpResponse, VCloudSession> {
    static final Pattern pattern = Pattern.compile("(vcloud-token)=?([^;]+)(;.*)?");
    private final ParseSax.Factory factory;
    private final Provider<OrgListHandler> orgHandlerProvider;

    @Inject
    private ParseLoginResponseFromHeaders(ParseSax.Factory factory, Provider<OrgListHandler> orgHandlerProvider) {
        this.factory = factory;
        this.orgHandlerProvider = orgHandlerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCloudSession apply(HttpResponse from) {
        try {
            final String token = this.parseTokenFromHeaders(from);
            final Map org = (Map)this.factory.create((ParseSax.HandlerWithResult)this.orgHandlerProvider.get()).parse((InputStream)Preconditions.checkNotNull((Object)from.getPayload().getInput(), (String)"no payload in http response to login request %s", (Object[])new Object[]{from}));
            VCloudSession vCloudSession = new VCloudSession(){

                @Override
                @VCloudToken
                public String getVCloudToken() {
                    return token;
                }

                @Override
                @Org
                public Map<String, ReferenceType> getOrgs() {
                    return org;
                }
            };
            return vCloudSession;
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)from);
        }
    }

    public String parseTokenFromHeaders(HttpResponse from) {
        String cookieHeader = from.getFirstHeaderOrNull("x-vcloud-authorization");
        if (cookieHeader != null) {
            Matcher matcher = pattern.matcher(cookieHeader);
            return matcher.find() ? matcher.group(2) : cookieHeader;
        }
        try {
            cookieHeader = (String)Iterables.find((Iterable)from.getHeaders().get((Object)"Set-Cookie"), (Predicate)Predicates.contains((Pattern)pattern));
            Matcher matcher = pattern.matcher(cookieHeader);
            matcher.find();
            return matcher.group(2);
        }
        catch (NoSuchElementException e) {
            throw new HttpResponseException(String.format("Header %s or %s must be present", "x-vcloud-authorization", "Set-Cookie"), null, from);
        }
    }
}

