/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.xml;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.trmk.vcloud_0_8.domain.InternetService;
import org.jclouds.trmk.vcloud_0_8.xml.InternetServiceHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class InternetServicesHandler
extends ParseSax.HandlerWithResult<Set<InternetService>> {
    private final InternetServiceHandler handler;
    private ImmutableSet.Builder<InternetService> builder = ImmutableSet.builder();
    int depth;
    private boolean inInternetService;

    @Inject
    public InternetServicesHandler(InternetServiceHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InternetService> getResult() {
        try {
            ImmutableSet immutableSet = this.builder.build();
            return immutableSet;
        }
        finally {
            this.builder = ImmutableSet.builder();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        ++this.depth;
        if (this.depth == 2) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"InternetService")) {
                this.inInternetService = true;
            }
        } else if (this.inInternetService) {
            this.handler.startElement(uri, localName, qName, attrs);
        }
    }

    public void endElement(String uri, String name, String qName) {
        --this.depth;
        if (this.depth == 1) {
            if (SaxUtils.equalsOrSuffix((String)qName, (String)"InternetService")) {
                this.inInternetService = false;
                this.builder.add((Object)this.handler.getResult());
            }
        } else if (this.inInternetService) {
            this.handler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inInternetService) {
            this.handler.characters(ch, start, length);
        }
    }
}

