/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;

@Singleton
public class ReturnVoidOnDeleteDefaultIp
implements Function<Exception, Void> {
    public static final Pattern MESSAGE_PATTERN = Pattern.compile(".*Cannot release this Public IP as it is default oubound IP.*");

    public Void apply(Exception from) {
        HttpResponseException hre;
        if (from instanceof HttpResponseException ? (hre = (HttpResponseException)from).getResponse().getStatusCode() == 503 || hre.getResponse().getStatusCode() == 401 || MESSAGE_PATTERN.matcher(hre.getMessage()).matches() : from instanceof AuthorizationException) {
            return null;
        }
        throw Throwables.propagate((Throwable)from);
    }
}

