/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.InternetService;
import org.jclouds.trmk.vcloud_0_8.domain.Node;
import org.jclouds.trmk.vcloud_0_8.domain.Protocol;
import org.jclouds.trmk.vcloud_0_8.domain.PublicIpAddress;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.Task;
import org.jclouds.trmk.vcloud_0_8.domain.TaskStatus;
import org.jclouds.trmk.vcloud_0_8.domain.TasksList;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;
import org.jclouds.trmk.vcloud_0_8.options.AddInternetServiceOptions;
import org.jclouds.trmk.vcloud_0_8.options.AddNodeOptions;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.suppliers.InternetServiceAndPublicIpAddressSupplier;

@Singleton
public class TerremarkVCloudComputeClient {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final TerremarkVCloudClient client;
    protected final Provider<String> passwordGenerator;
    protected final InternetServiceAndPublicIpAddressSupplier internetServiceAndPublicIpAddressSupplier;
    protected final Map<Status, NodeMetadata.Status> vAppStatusToNodeStatus;
    protected final Predicate<URI> taskTester;

    @Inject
    protected TerremarkVCloudComputeClient(TerremarkVCloudClient client, @Named(value="PASSWORD") Provider<String> passwordGenerator, Predicate<URI> successTester, Map<Status, NodeMetadata.Status> vAppStatusToNodeStatus, Map<String, Credentials> credentialStore, InternetServiceAndPublicIpAddressSupplier internetServiceAndPublicIpAddressSupplier) {
        this.client = client;
        this.passwordGenerator = passwordGenerator;
        this.internetServiceAndPublicIpAddressSupplier = internetServiceAndPublicIpAddressSupplier;
        this.vAppStatusToNodeStatus = vAppStatusToNodeStatus;
        this.taskTester = successTester;
    }

    protected Status getStatus(VApp vApp) {
        return vApp.getStatus();
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<VApp> startAndReturnCredentials(@Nullable URI VDC2, URI templateId, String name, InstantiateVAppTemplateOptions options, int ... portsToOpen) {
        if (portsToOpen.length > 0 && !options.shouldBlock()) {
            throw new IllegalArgumentException("We cannot open ports on terremark unless we can deploy the vapp");
        }
        String password = null;
        VAppTemplate template = this.client.getVAppTemplate(templateId);
        if (template.getDescription().indexOf("Windows") != -1) {
            password = (String)this.passwordGenerator.get();
            options.getProperties().put("password", password);
        }
        Preconditions.checkNotNull((Object)options, (Object)"options");
        this.logger.debug(">> instantiating vApp vDC(%s) template(%s) name(%s) options(%s) ", new Object[]{VDC2, templateId, name, options});
        VApp vAppResponse = this.client.instantiateVAppTemplateInVDC(VDC2, templateId, name, options);
        this.logger.debug("<< instantiated VApp(%s)", new Object[]{vAppResponse.getName()});
        if (options.shouldDeploy()) {
            this.logger.debug(">> deploying vApp(%s)", new Object[]{vAppResponse.getName()});
            Task task = this.client.deployVApp(vAppResponse.getHref());
            if (options.shouldBlock()) {
                if (!this.taskTester.apply((Object)task.getHref())) {
                    throw new RuntimeException(String.format("failed to %s %s: %s", "deploy", vAppResponse.getName(), task));
                }
                this.logger.debug("<< deployed vApp(%s)", new Object[]{vAppResponse.getName()});
                if (options.shouldPowerOn()) {
                    this.logger.debug(">> powering vApp(%s)", new Object[]{vAppResponse.getName()});
                    task = this.client.powerOnVApp(vAppResponse.getHref());
                    if (!this.taskTester.apply((Object)task.getHref())) {
                        throw new RuntimeException(String.format("failed to %s %s: %s", "powerOn", vAppResponse.getName(), task));
                    }
                    this.logger.debug("<< on vApp(%s)", new Object[]{vAppResponse.getName()});
                }
            }
        }
        if (portsToOpen.length > 0) {
            this.createPublicAddressMappedToPorts(vAppResponse.getHref(), portsToOpen);
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)vAppResponse, vAppResponse.getHref().toASCIIString(), password != null ? LoginCredentials.builder().password(password).build() : null);
    }

    public VApp start(@Nullable URI VDC2, URI templateId, String name, InstantiateVAppTemplateOptions options, int ... portsToOpen) {
        return (VApp)this.startAndReturnCredentials(VDC2, templateId, name, options, portsToOpen).getNode();
    }

    public String createPublicAddressMappedToPorts(URI vAppId, int ... ports) {
        VApp vApp = this.client.getVApp(vAppId);
        PublicIpAddress ip = null;
        String privateAddress = (String)Iterables.getLast((Iterable)vApp.getNetworkToAddresses().values());
        for (int port : ports) {
            Protocol protocol;
            InternetService is = null;
            switch (port) {
                case 22: {
                    protocol = Protocol.TCP;
                    break;
                }
                case 80: 
                case 8080: {
                    protocol = Protocol.HTTP;
                    break;
                }
                case 443: {
                    protocol = Protocol.HTTPS;
                    break;
                }
                default: {
                    protocol = Protocol.HTTP;
                }
            }
            if (ip == null) {
                Map.Entry<InternetService, PublicIpAddress> entry = this.internetServiceAndPublicIpAddressSupplier.getNewInternetServiceAndIp(vApp, port, protocol);
                is = entry.getKey();
                ip = entry.getValue();
            } else {
                this.logger.debug(">> adding InternetService %s:%s:%d", new Object[]{ip.getAddress(), protocol, port});
                is = this.client.addInternetServiceToExistingIp(ip.getId(), vApp.getName() + "-" + port, protocol, port, AddInternetServiceOptions.Builder.withDescription(String.format("port %d access to serverId: %s name: %s", port, vApp.getName(), vApp.getName())));
            }
            this.logger.debug("<< created InternetService(%s) %s:%s:%d", new Object[]{is.getName(), is.getPublicIpAddress().getAddress(), is.getProtocol(), is.getPort()});
            this.logger.debug(">> adding Node %s:%d -> %s:%d", new Object[]{is.getPublicIpAddress().getAddress(), is.getPort(), privateAddress, port});
            Node node = this.client.addNode(is.getId(), privateAddress, vApp.getName() + "-" + port, port, new AddNodeOptions[0]);
            this.logger.debug("<< added Node(%s)", new Object[]{node.getName()});
        }
        return ip != null ? ip.getAddress() : null;
    }

    private Set<PublicIpAddress> deleteInternetServicesAndNodesAssociatedWithVApp(VApp vApp) {
        Preconditions.checkNotNull((Object)vApp.getVDC(), (String)"VDC reference missing for vApp(%s)", (Object[])new Object[]{vApp.getName()});
        HashSet ipAddresses = Sets.newHashSet();
        block0: for (InternetService service : this.client.getAllInternetServicesInVDC(vApp.getVDC().getHref())) {
            for (Node node : this.client.getNodes(service.getId())) {
                if (!vApp.getNetworkToAddresses().containsValue((Object)node.getIpAddress())) continue;
                ipAddresses.add(service.getPublicIpAddress());
                this.logger.debug(">> deleting Node(%s) %s:%d -> %s:%d", new Object[]{node.getName(), service.getPublicIpAddress().getAddress(), service.getPort(), node.getIpAddress(), node.getPort()});
                this.client.deleteNode(node.getId());
                this.logger.debug("<< deleted Node(%s)", new Object[]{node.getName()});
                Set<Node> nodes = this.client.getNodes(service.getId());
                if (nodes.size() != 0) continue;
                this.logger.debug(">> deleting InternetService(%s) %s:%d", new Object[]{service.getName(), service.getPublicIpAddress().getAddress(), service.getPort()});
                this.client.deleteInternetService(service.getId());
                this.logger.debug("<< deleted InternetService(%s)", new Object[]{service.getName()});
                continue block0;
            }
        }
        return ipAddresses;
    }

    private void deletePublicIpAddressesWithNoServicesAttached(Set<PublicIpAddress> ipAddresses) {
        for (PublicIpAddress address : ipAddresses) {
            Set<InternetService> services = this.client.getInternetServicesOnPublicIp(address.getId());
            if (services.size() != 0) continue;
            this.logger.debug(">> deleting PublicIpAddress(%s) %s", new Object[]{address.getId(), address.getAddress()});
            try {
                this.client.deletePublicIp(address.getId());
                this.logger.debug("<< deleted PublicIpAddress(%s)", new Object[]{address.getId()});
            }
            catch (Exception e) {
                this.logger.trace("cannot delete PublicIpAddress(%s) as it is unsupported", new Object[]{address.getId()});
            }
        }
    }

    public void stop(URI id) {
        VApp vApp = this.client.getVApp(id);
        if (vApp == null) {
            return;
        }
        Set<PublicIpAddress> ipAddresses = this.deleteInternetServicesAndNodesAssociatedWithVApp(vApp);
        this.deletePublicIpAddressesWithNoServicesAttached(ipAddresses);
        if (vApp.getStatus() != Status.OFF) {
            try {
                this.powerOffAndWait(vApp);
            }
            catch (IllegalStateException e) {
                this.logger.warn("<< %s vApp(%s)", new Object[]{e.getMessage(), vApp.getName()});
                this.blockOnLastTask(vApp);
                this.powerOffAndWait(vApp);
            }
            vApp = this.client.getVApp(id);
            this.logger.debug("<< %s vApp(%s)", new Object[]{vApp.getStatus(), vApp.getName()});
        }
        this.logger.debug(">> deleting vApp(%s)", new Object[]{vApp.getName()});
        this.client.deleteVApp(id);
        this.logger.debug("<< deleted vApp(%s))", new Object[]{vApp.getName()});
    }

    private void powerOffAndWait(VApp vApp) {
        this.logger.debug(">> powering off vApp(%s), current status: %s", new Object[]{vApp.getName(), vApp.getStatus()});
        Task task = this.client.powerOffVApp(vApp.getHref());
        if (!this.taskTester.apply((Object)task.getHref())) {
            throw new RuntimeException(String.format("failed to %s %s: %s", "powerOff", vApp.getName(), task));
        }
    }

    void blockOnLastTask(VApp vApp) {
        TasksList list = this.client.findTasksListInOrgNamed(null, null);
        try {
            Task lastTask = (Task)Iterables.getLast((Iterable)Iterables.filter(list.getTasks(), (Predicate)new Predicate<Task>(){

                public boolean apply(Task input) {
                    return input.getStatus() == TaskStatus.QUEUED || input.getStatus() == TaskStatus.RUNNING;
                }
            }));
            if (!this.taskTester.apply((Object)lastTask.getHref())) {
                throw new RuntimeException(String.format("failed to %s %s: %s", "powerOff", vApp.getName(), lastTask));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public Set<String> getPrivateAddresses(URI id) {
        VApp vApp = this.client.getVApp(id);
        if (vApp != null) {
            return Sets.newHashSet((Iterable)vApp.getNetworkToAddresses().values());
        }
        return ImmutableSet.of();
    }

    public Set<String> getPublicAddresses(URI id) {
        VApp vApp = this.client.getVApp(id);
        if (vApp != null) {
            HashSet ipAddresses = Sets.newHashSet();
            for (InternetService service : this.client.getAllInternetServicesInVDC(vApp.getVDC().getHref())) {
                for (Node node : this.client.getNodes(service.getId())) {
                    if (!vApp.getNetworkToAddresses().containsValue((Object)node.getIpAddress())) continue;
                    ipAddresses.add(service.getPublicIpAddress().getAddress());
                }
            }
            return ipAddresses;
        }
        return ImmutableSet.of();
    }

    public void reset(URI id) {
        VApp vApp = this.refreshVApp(id);
        this.logger.debug(">> resetting vApp(%s)", new Object[]{vApp.getName()});
        Task task = this.reset(vApp);
        if (!this.taskTester.apply((Object)task.getHref())) {
            throw new RuntimeException(String.format("failed to %s %s: %s", "resetVApp", vApp.getName(), task));
        }
        this.logger.debug("<< on vApp(%s)", new Object[]{vApp.getName()});
    }

    protected void deleteVApp(VApp vApp) {
        this.logger.debug(">> deleting vApp(%s)", new Object[]{vApp.getName()});
        Task task = this.client.deleteVApp(vApp.getHref());
        if (task != null && !this.taskTester.apply((Object)task.getHref())) {
            throw new RuntimeException(String.format("failed to %s %s: %s", "delete", vApp.getName(), task));
        }
    }

    protected VApp refreshVApp(URI id) {
        return this.client.getVApp(id);
    }

    protected Task powerOff(VApp vApp) {
        return this.client.powerOffVApp(vApp.getHref());
    }

    protected Task reset(VApp vApp) {
        return this.client.resetVApp(vApp.getHref());
    }

    protected Task undeploy(VApp vApp) {
        return this.client.undeployVApp(vApp.getHref());
    }
}

