/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeMetadataBuilder;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.logging.Logger;
import org.jclouds.trmk.vcloud_0_8.TerremarkVCloudClient;
import org.jclouds.trmk.vcloud_0_8.compute.functions.FindLocationForResource;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.TerremarkVCloudGetNodeMetadataStrategy;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class TerremarkVCloudListNodesStrategy
implements ListNodesStrategy {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    protected final TerremarkVCloudGetNodeMetadataStrategy getNodeMetadata;
    protected final TerremarkVCloudClient client;
    protected final FindLocationForResource findLocationForResourceInVDC;
    Set<String> blackListVAppNames = ImmutableSet.of();
    private final Supplier<Map<String, ReferenceType>> orgNameToEndpoint;

    @Inject(optional=true)
    void setBlackList(@Named(value="jclouds.compute.blacklist-nodes") String blackListNodes) {
        if (blackListNodes != null && !"".equals(blackListNodes)) {
            this.blackListVAppNames = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)blackListNodes));
        }
    }

    @Inject
    protected TerremarkVCloudListNodesStrategy(TerremarkVCloudClient client, @Org Supplier<Map<String, ReferenceType>> orgNameToEndpoint, TerremarkVCloudGetNodeMetadataStrategy getNodeMetadata, FindLocationForResource findLocationForResourceInVDC) {
        this.client = client;
        this.orgNameToEndpoint = orgNameToEndpoint;
        this.getNodeMetadata = getNodeMetadata;
        this.findLocationForResourceInVDC = findLocationForResourceInVDC;
    }

    public Iterable<ComputeMetadata> listNodes() {
        HashSet nodes = Sets.newHashSet();
        for (String org : ((Map)this.orgNameToEndpoint.get()).keySet()) {
            for (ReferenceType vdc : this.client.findOrgNamed(org).getVDCs().values()) {
                for (ReferenceType resource : this.client.getVDC(vdc.getHref()).getResourceEntities().values()) {
                    if (!this.validVApp(resource)) continue;
                    nodes.add(this.convertVAppToComputeMetadata(vdc, resource));
                }
            }
        }
        return nodes;
    }

    private boolean validVApp(ReferenceType resource) {
        return resource.getType().equals("application/vnd.vmware.vcloud.vApp+xml") && !this.blackListVAppNames.contains(resource.getName());
    }

    private ComputeMetadata convertVAppToComputeMetadata(ReferenceType vdc, ReferenceType resource) {
        ComputeMetadataBuilder builder = new ComputeMetadataBuilder(ComputeType.NODE);
        builder.providerId(resource.getHref().toASCIIString());
        builder.name(resource.getName());
        builder.id(resource.getHref().toASCIIString());
        builder.location(this.findLocationForResourceInVDC.apply(vdc));
        return builder.build();
    }

    public Iterable<NodeMetadata> listDetailsOnNodesMatching(Predicate<ComputeMetadata> filter) {
        HashSet nodes = Sets.newHashSet();
        for (String org : ((Map)this.orgNameToEndpoint.get()).keySet()) {
            for (ReferenceType vdc : this.client.findOrgNamed(org).getVDCs().values()) {
                for (ReferenceType resource : this.client.getVDC(vdc.getHref()).getResourceEntities().values()) {
                    if (!this.validVApp(resource) || !filter.apply((Object)this.convertVAppToComputeMetadata(vdc, resource))) continue;
                    this.addVAppToSetRetryingIfNotYetPresent(nodes, vdc, resource);
                }
            }
        }
        return nodes;
    }

    @VisibleForTesting
    void addVAppToSetRetryingIfNotYetPresent(Set<NodeMetadata> nodes, ReferenceType vdc, ReferenceType resource) {
        NodeMetadata node = null;
        int i = 0;
        while (node == null && i++ < 3) {
            try {
                node = this.getNodeMetadata.getNode(resource.getHref().toASCIIString());
                nodes.add(node);
            }
            catch (NullPointerException e) {
                this.logger.warn("vApp %s not yet present in vdc %s", new Object[]{resource.getName(), vdc.getName()});
            }
        }
    }
}

