/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Objects;
import java.net.URI;

public class Subnet
implements Comparable<Subnet> {
    private final URI href;
    private final String name;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Subnet.builder().fromSubnet(this);
    }

    public Subnet(URI href, String name) {
        this.href = href;
        this.name = name;
    }

    @Override
    public int compareTo(Subnet that) {
        return this == that ? 0 : this.getHref().compareTo(that.getHref());
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subnet that = (Subnet)Subnet.class.cast(o);
        return Objects.equal((Object)this.href, (Object)that.href) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.href, this.name});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").add("href", (Object)this.href).add("name", (Object)this.name).toString();
    }

    public static class Builder {
        private URI href;
        private String name;

        public Builder href(URI href) {
            this.href = href;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Subnet build() {
            return new Subnet(this.href, this.name);
        }

        public Builder fromSubnet(Subnet in) {
            return this.href(in.getHref()).name(in.getName());
        }
    }
}

