/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain.internal;

import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudError;

public class ErrorImpl
implements VCloudError {
    private final String message;
    private final int majorErrorCode;
    private final VCloudError.MinorCode minorErrorCode;
    @Nullable
    private final String vendorSpecificErrorCode;
    @Nullable
    private final String stackTrace;

    public ErrorImpl(String message, int majorErrorCode, @Nullable VCloudError.MinorCode minorErrorCode, @Nullable String vendorSpecificErrorCode, @Nullable String stackTrace) {
        this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
        this.majorErrorCode = majorErrorCode;
        this.minorErrorCode = minorErrorCode;
        this.vendorSpecificErrorCode = vendorSpecificErrorCode;
        this.stackTrace = stackTrace;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getMajorErrorCode() {
        return this.majorErrorCode;
    }

    @Override
    public VCloudError.MinorCode getMinorErrorCode() {
        return this.minorErrorCode;
    }

    @Override
    public String getVendorSpecificErrorCode() {
        return this.vendorSpecificErrorCode;
    }

    @Override
    public String getStackTrace() {
        return this.stackTrace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.majorErrorCode;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.minorErrorCode == null ? 0 : this.minorErrorCode.hashCode());
        result = 31 * result + (this.stackTrace == null ? 0 : this.stackTrace.hashCode());
        result = 31 * result + (this.vendorSpecificErrorCode == null ? 0 : this.vendorSpecificErrorCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorImpl other = (ErrorImpl)obj;
        if (this.majorErrorCode != other.majorErrorCode) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.minorErrorCode == null ? other.minorErrorCode != null : !this.minorErrorCode.equals((Object)other.minorErrorCode)) {
            return false;
        }
        if (this.stackTrace == null ? other.stackTrace != null : !this.stackTrace.equals(other.stackTrace)) {
            return false;
        }
        return !(this.vendorSpecificErrorCode == null ? other.vendorSpecificErrorCode != null : !this.vendorSpecificErrorCode.equals(other.vendorSpecificErrorCode));
    }

    public String toString() {
        return "[majorErrorCode=" + this.majorErrorCode + ", message=" + this.message + ", minorErrorCode=" + (Object)((Object)this.minorErrorCode) + ", stackTrace=" + this.stackTrace + ", vendorSpecificErrorCode=" + this.vendorSpecificErrorCode + "]";
    }
}

