/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.strategy;

import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.LocationScope;
import org.jclouds.trmk.vcloud_0_8.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.compute.strategy.CreateNewKeyPairUnlessUserSpecifiedOtherwise;

@Singleton
public class TerremarkEncodeTagIntoNameRunNodesAndAddToSetStrategy
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    private final CreateNewKeyPairUnlessUserSpecifiedOtherwise createNewKeyPairUnlessUserSpecifiedOtherwise;

    @Inject
    protected TerremarkEncodeTagIntoNameRunNodesAndAddToSetStrategy(CreateNodeWithGroupEncodedIntoName addNodeWithTagStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, @Named(value="jclouds.user-threads") ExecutorService executor, CreateNewKeyPairUnlessUserSpecifiedOtherwise createNewKeyPairUnlessUserSpecifiedOtherwise) {
        super(addNodeWithTagStrategy, listNodesStrategy, namingConvention, executor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.createNewKeyPairUnlessUserSpecifiedOtherwise = createNewKeyPairUnlessUserSpecifiedOtherwise;
    }

    public Map<?, Future<Void>> execute(String tag, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        assert (template.getLocation().getParent().getScope() == LocationScope.REGION) : "template location should have a parent of org, which should be mapped to region: " + template.getLocation();
        String orgId = template.getLocation().getParent().getId();
        assert (orgId.startsWith("http")) : "parent id should be a rest url: " + template.getLocation().getParent();
        this.createNewKeyPairUnlessUserSpecifiedOtherwise.execute(URI.create(orgId), tag, template.getImage().getDefaultCredentials().identity, (TerremarkVCloudTemplateOptions)template.getOptions().as(TerremarkVCloudTemplateOptions.class));
        return super.execute(tag, count, template, goodNodes, badNodes, customizationResponses);
    }
}

