/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.Catalog;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;

@Singleton
public class OrgNameCatalogNameVAppTemplateNameToEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, Map<String, Map<String, ? extends CatalogItem>>>> orgCatalogItemMap;
    private final Supplier<ReferenceType> defaultOrg;
    private final Supplier<ReferenceType> defaultCatalog;

    @Inject
    public OrgNameCatalogNameVAppTemplateNameToEndpoint(Supplier<Map<String, Map<String, Map<String, ? extends CatalogItem>>>> orgCatalogItemMap, @Org Supplier<ReferenceType> defaultOrg, @Catalog Supplier<ReferenceType> defaultCatalog) {
        this.orgCatalogItemMap = orgCatalogItemMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    public URI apply(Object from) {
        Map orgCatalogItemMap;
        Iterable orgCatalog = (Iterable)Preconditions.checkNotNull((Object)from, (Object)"args");
        Object org = Iterables.get((Iterable)orgCatalog, (int)0);
        Object catalog = Iterables.get((Iterable)orgCatalog, (int)1);
        Object catalogItem = Iterables.get((Iterable)orgCatalog, (int)2);
        if (org == null) {
            org = ((ReferenceType)this.defaultOrg.get()).getName();
        }
        if (catalog == null) {
            catalog = ((ReferenceType)this.defaultCatalog.get()).getName();
        }
        if (!(orgCatalogItemMap = (Map)this.orgCatalogItemMap.get()).containsKey(org)) {
            throw new NoSuchElementException("org: " + org + " not found in " + orgCatalogItemMap.keySet());
        }
        Map catalogs = (Map)orgCatalogItemMap.get(org);
        if (!catalogs.containsKey(catalog)) {
            throw new NoSuchElementException("catalog: " + org + "/" + catalog + " not found in " + catalogs.keySet());
        }
        Map catalogMap = (Map)catalogs.get(catalog);
        if (!catalogMap.containsKey(catalogItem)) {
            throw new NoSuchElementException("item: " + org + "/" + catalog + "/" + catalogItem + " not found in " + catalogMap.keySet());
        }
        CatalogItem item = (CatalogItem)catalogMap.get(catalogItem);
        return ((ReferenceType)Preconditions.checkNotNull((Object)item.getEntity(), (Object)("item: " + org + "/" + catalog + "/" + catalogItem + " has no entity"))).getHref();
    }
}

