/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.trmk.vcloud_0_8.compute.functions.FindLocationForResource;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VAppTemplate;

public class ImageForVCloudExpressVAppTemplate
implements Function<VAppTemplate, Image> {
    private final Map<Status, Image.Status> toPortableImageStatus;
    private final FindLocationForResource findLocationForResource;
    private final PopulateDefaultLoginCredentialsForImageStrategy credentialsProvider;
    private final Function<String, OperatingSystem> osParser;
    private ReferenceType parent;

    @Inject
    protected ImageForVCloudExpressVAppTemplate(Map<Status, Image.Status> toPortableImageStatus, FindLocationForResource findLocationForResource, PopulateDefaultLoginCredentialsForImageStrategy credentialsProvider, Function<String, OperatingSystem> osParser) {
        this.toPortableImageStatus = (Map)Preconditions.checkNotNull(toPortableImageStatus, (Object)"toPortableImageStatus");
        this.findLocationForResource = (FindLocationForResource)Preconditions.checkNotNull((Object)findLocationForResource, (Object)"findLocationForResource");
        this.credentialsProvider = (PopulateDefaultLoginCredentialsForImageStrategy)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"credentialsProvider");
        this.osParser = osParser;
    }

    public ImageForVCloudExpressVAppTemplate withParent(ReferenceType parent) {
        this.parent = parent;
        return this;
    }

    public Image apply(VAppTemplate from) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        builder.location(this.findLocationForResource.apply((ReferenceType)Preconditions.checkNotNull((Object)this.parent, (Object)"parent")));
        builder.description(from.getDescription() != null ? from.getDescription() : from.getName());
        builder.operatingSystem((OperatingSystem)this.osParser.apply((Object)from.getName()));
        builder.status(this.toPortableImageStatus.get((Object)from.getStatus()));
        builder.defaultCredentials(this.credentialsProvider.apply((Object)from));
        return builder.build();
    }
}

