/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.cim.CIMPredicates;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.vcloud_0_8.domain.Status;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.jclouds.trmk.vcloud_0_8.domain.VAppConfiguration;

@Singleton
public class BindVAppConfigurationToXmlPayload
implements MapBinder,
Function<Object, URI> {
    private static final String RESOURCE_ALLOCATION_NS = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData";
    protected final String ns;
    protected final String schema;
    protected final BindToStringPayload stringBinder;
    protected final String apiVersion;

    @Inject
    public BindVAppConfigurationToXmlPayload(@ApiVersion String apiVersion, BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema) {
        this.apiVersion = apiVersion;
        this.ns = ns;
        this.schema = schema;
        this.stringBinder = stringBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState((gRequest.getArgs() != null ? 1 : 0) != 0, (Object)"args should be initialized at this point");
        VApp vApp = (VApp)Preconditions.checkNotNull((Object)this.findVAppInArgsOrNull(gRequest), (Object)"vApp");
        Preconditions.checkArgument((vApp.getStatus() == Status.OFF ? 1 : 0) != 0, (Object)"vApp must be off!");
        VAppConfiguration configuration = (VAppConfiguration)Preconditions.checkNotNull((Object)this.findConfigInArgsOrNull(gRequest), (Object)"config");
        try {
            return (R)this.stringBinder.bindToRequest(request, (Object)this.generateXml(vApp, configuration));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateXml(VApp vApp, VAppConfiguration configuration) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        String name = configuration.getName() != null ? configuration.getName() : vApp.getName();
        XMLBuilder rootBuilder = this.buildRoot(vApp, name);
        XMLBuilder sectionBuilder = rootBuilder.e("Section").a("xsi:type", "VirtualHardwareSection_Type").a("xmlns", "http://schemas.dmtf.org/ovf/envelope/1").a("xmlns:q2", "http://www.vmware.com/vcloud/v1");
        sectionBuilder.e("Info").t("Virtual Hardware");
        this.addProcessorItem(sectionBuilder, vApp, configuration);
        this.addMemoryItem(sectionBuilder, vApp, configuration);
        this.addDiskItems(sectionBuilder, vApp, configuration);
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    private void addProcessorItem(XMLBuilder sectionBuilder, VApp vApp, VAppConfiguration configuration) {
        ResourceAllocationSettingData cpu = (ResourceAllocationSettingData)Iterables.find(vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.PROCESSOR}));
        long quantity = configuration.getProcessorCount() != null ? (long)configuration.getProcessorCount().intValue() : cpu.getVirtualQuantity();
        this.addResourceWithQuantity(sectionBuilder, cpu, quantity);
    }

    private void addMemoryItem(XMLBuilder sectionBuilder, VApp vApp, VAppConfiguration configuration) {
        ResourceAllocationSettingData memory = (ResourceAllocationSettingData)Iterables.find(vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.MEMORY}));
        long quantity = configuration.getMemory() != null ? configuration.getMemory() : memory.getVirtualQuantity();
        this.addResourceWithQuantity(sectionBuilder, memory, quantity);
    }

    private void addDiskItems(XMLBuilder sectionBuilder, VApp vApp, VAppConfiguration configuration) {
        for (ResourceAllocationSettingData disk : Iterables.filter(vApp.getResourceAllocations(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.DISK_DRIVE}))) {
            if (configuration.getDisksToDelete().contains(Integer.valueOf(disk.getAddressOnParent()))) continue;
            this.addDiskWithQuantity(sectionBuilder, disk);
        }
        for (Long quantity : configuration.getDisks()) {
            ResourceAllocationSettingData disk = ResourceAllocationSettingData.builder().instanceID("9").addressOnParent("-1").elementName("").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).virtualQuantity(quantity).build();
            this.addDiskWithQuantity(sectionBuilder, disk);
        }
    }

    private XMLBuilder addResourceWithQuantity(XMLBuilder sectionBuilder, ResourceAllocationSettingData resource, long quantity) {
        XMLBuilder itemBuilder = sectionBuilder.e("Item");
        this.addCommonElements(itemBuilder, resource, quantity);
        return itemBuilder;
    }

    private void addCommonElements(XMLBuilder itemBuilder, ResourceAllocationSettingData resource, long quantity) {
        itemBuilder.e("InstanceID").a("xmlns", RESOURCE_ALLOCATION_NS).t(resource.getInstanceID() + "");
        itemBuilder.e("ResourceType").a("xmlns", RESOURCE_ALLOCATION_NS).t(resource.getResourceType().value());
        itemBuilder.e("VirtualQuantity").a("xmlns", RESOURCE_ALLOCATION_NS).t(quantity + "");
    }

    private XMLBuilder addDiskWithQuantity(XMLBuilder sectionBuilder, ResourceAllocationSettingData disk) {
        XMLBuilder itemBuilder = sectionBuilder.e("Item");
        itemBuilder.e("AddressOnParent").a("xmlns", RESOURCE_ALLOCATION_NS).t(disk.getAddressOnParent() + "");
        for (String hostResource : disk.getHostResources()) {
            itemBuilder.e("HostResource").a("xmlns", RESOURCE_ALLOCATION_NS).t(hostResource);
        }
        this.addCommonElements(itemBuilder, disk, disk.getVirtualQuantity());
        return itemBuilder;
    }

    protected XMLBuilder buildRoot(VApp vApp, String name) throws ParserConfigurationException, FactoryConfigurationError {
        String status = vApp.getStatus().value();
        if (this.apiVersion.indexOf("0.8") != -1 && "8".equals(status)) {
            status = "2";
        }
        XMLBuilder rootBuilder = XMLBuilder.create((String)"VApp").a("type", vApp.getType()).a("name", name).a("status", status).a("size", vApp.getSize() + "").a("xmlns", this.ns).a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("xsi:schemaLocation", this.ns + " " + this.schema);
        return rootBuilder;
    }

    protected VApp findVAppInArgsOrNull(GeneratedHttpRequest gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof VApp) {
                return (VApp)arg;
            }
            if (!(arg instanceof VApp[])) continue;
            VApp[] vapps = (VApp[])arg;
            return vapps.length > 0 ? vapps[0] : null;
        }
        return null;
    }

    protected VAppConfiguration findConfigInArgsOrNull(GeneratedHttpRequest gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof VAppConfiguration) {
                return (VAppConfiguration)arg;
            }
            if (!(arg instanceof VAppConfiguration[])) continue;
            VAppConfiguration[] configuration = (VAppConfiguration[])arg;
            return configuration.length > 0 ? configuration[0] : null;
        }
        return null;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException("BindVAppConfigurationToXmlPayload needs parameters");
    }

    protected String ifNullDefaultTo(String value, String defaultValue) {
        return value != null ? value : (String)Preconditions.checkNotNull((Object)defaultValue, (Object)"defaultValue");
    }

    public URI apply(Object from) {
        return ((VApp)VApp.class.cast(Preconditions.checkNotNull((Object)from, (Object)"from"))).getHref();
    }
}

