/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.util.Preconditions2;

public class VAppConfiguration {
    private String name = null;
    private Integer processorCount = null;
    private Long memory = null;
    private List<Long> disks = Lists.newArrayList();
    private List<Integer> disksToDelete = Lists.newArrayList();

    public VAppConfiguration changeNameTo(String name) {
        Preconditions2.checkNotEmpty((String)name, (String)"name must be specified");
        this.name = name;
        return this;
    }

    public VAppConfiguration changeProcessorCountTo(int cpus) {
        Preconditions.checkArgument((cpus >= 1 ? 1 : 0) != 0, (Object)"cpu count must be positive");
        this.processorCount = cpus;
        return this;
    }

    public VAppConfiguration changeMemoryTo(long megabytes) {
        Preconditions.checkArgument((megabytes >= 1L ? 1 : 0) != 0, (Object)"megabytes must be positive");
        this.memory = megabytes;
        return this;
    }

    public VAppConfiguration addDisk(long kilobytes) {
        Preconditions.checkArgument((kilobytes > 0L ? 1 : 0) != 0, (Object)"kilobytes must be positive");
        Preconditions.checkArgument((kilobytes % 0x100000L == 0L ? 1 : 0) != 0, (Object)"disk must be an interval of 1048576");
        this.disks.add(kilobytes);
        return this;
    }

    public VAppConfiguration deleteDiskWithAddressOnParent(int addressOnParent) {
        Preconditions.checkArgument((addressOnParent > 0 ? 1 : 0) != 0, (Object)"you cannot delete the system disk");
        this.disksToDelete.add(addressOnParent);
        return this;
    }

    public Integer getProcessorCount() {
        return this.processorCount;
    }

    public Long getMemory() {
        return this.memory;
    }

    public List<Long> getDisks() {
        return this.disks;
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getDisksToDelete() {
        return this.disksToDelete;
    }

    public static class Builder {
        public static VAppConfiguration changeNameTo(String name) {
            VAppConfiguration options = new VAppConfiguration();
            return options.changeNameTo(name);
        }

        public static VAppConfiguration changeProcessorCountTo(int cpus) {
            VAppConfiguration options = new VAppConfiguration();
            return options.changeProcessorCountTo(cpus);
        }

        public static VAppConfiguration changeMemoryTo(long megabytes) {
            VAppConfiguration options = new VAppConfiguration();
            return options.changeMemoryTo(megabytes);
        }

        public static VAppConfiguration addDisk(long kilobytes) {
            VAppConfiguration options = new VAppConfiguration();
            return options.addDisk(kilobytes);
        }

        public static VAppConfiguration deleteDiskWithAddressOnParent(int addressOnParent) {
            VAppConfiguration options = new VAppConfiguration();
            return options.deleteDiskWithAddressOnParent(addressOnParent);
        }
    }
}

