/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.options;

import com.google.common.base.Preconditions;

public class CloneVAppOptions {
    private boolean deploy;
    private boolean powerOn;
    private String description;

    public CloneVAppOptions deploy() {
        this.deploy = true;
        return this;
    }

    public CloneVAppOptions powerOn() {
        Preconditions.checkState((boolean)this.deploy, (Object)"must set deploy before setting powerOn");
        this.powerOn = true;
        return this;
    }

    public CloneVAppOptions withDescription(String description) {
        Preconditions.checkNotNull((Object)description, (Object)"description");
        this.description = description;
        return this;
    }

    public boolean isDeploy() {
        return this.deploy;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public String getDescription() {
        return this.description;
    }

    public static class Builder {
        public static CloneVAppOptions deploy() {
            CloneVAppOptions options = new CloneVAppOptions();
            return options.deploy();
        }

        public static CloneVAppOptions powerOn() {
            CloneVAppOptions options = new CloneVAppOptions();
            return options.powerOn();
        }

        public static CloneVAppOptions withDescription(String description) {
            CloneVAppOptions options = new CloneVAppOptions();
            return options.withDescription(description);
        }
    }
}

