/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.config;

import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateBuilderImpl;
import org.jclouds.aws.ec2.compute.config.AWSEC2ComputeServiceDependenciesModule;
import org.jclouds.aws.ec2.compute.functions.AWSRunningInstanceToNodeMetadata;
import org.jclouds.aws.ec2.compute.predicates.AWSEC2InstancePresent;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2CreateNodesInGroupThenAddToSet;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2DestroyNodeStrategy;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2GetNodeMetadataStrategy;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2ListNodesStrategy;
import org.jclouds.aws.ec2.compute.strategy.AWSEC2ReviseParsedImage;
import org.jclouds.aws.ec2.compute.strategy.CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.aws.ec2.compute.suppliers.AWSEC2HardwareSupplier;
import org.jclouds.aws.ec2.compute.suppliers.AWSRegionAndNameToImageSupplier;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.config.EC2BindComputeStrategiesByClass;
import org.jclouds.ec2.compute.config.EC2BindComputeSuppliersByClass;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.predicates.InstancePresent;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.strategy.EC2CreateNodesInGroupThenAddToSet;
import org.jclouds.ec2.compute.strategy.EC2DestroyNodeStrategy;
import org.jclouds.ec2.compute.strategy.EC2GetNodeMetadataStrategy;
import org.jclouds.ec2.compute.strategy.EC2ListNodesStrategy;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.compute.suppliers.EC2HardwareSupplier;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;

public class AWSEC2ComputeServiceContextModule
extends BaseComputeServiceContextModule {
    protected void configure() {
        super.configure();
        this.installDependencies();
        this.install((Module)new EC2BindComputeStrategiesByClass());
        this.install((Module)new EC2BindComputeSuppliersByClass());
        this.bind(ReviseParsedImage.class).to(AWSEC2ReviseParsedImage.class);
        this.bind(CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions.class).to(CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions.class);
        this.bind(EC2HardwareSupplier.class).to(AWSEC2HardwareSupplier.class);
        this.bind(EC2TemplateBuilderImpl.class).to(AWSEC2TemplateBuilderImpl.class);
        this.bind(EC2GetNodeMetadataStrategy.class).to(AWSEC2GetNodeMetadataStrategy.class);
        this.bind(EC2ListNodesStrategy.class).to(AWSEC2ListNodesStrategy.class);
        this.bind(EC2DestroyNodeStrategy.class).to(AWSEC2DestroyNodeStrategy.class);
        this.bind(InstancePresent.class).to(AWSEC2InstancePresent.class);
        this.bind(EC2CreateNodesInGroupThenAddToSet.class).to(AWSEC2CreateNodesInGroupThenAddToSet.class);
        this.bind(RunningInstanceToNodeMetadata.class).to(AWSRunningInstanceToNodeMetadata.class);
    }

    protected void installDependencies() {
        this.install((Module)new AWSEC2ComputeServiceDependenciesModule());
    }

    @Provides
    @Singleton
    protected Supplier<Cache<RegionAndName, ? extends Image>> provideRegionAndNameToImageSupplierCache(@Named(value="jclouds.session-interval") long seconds, final AWSRegionAndNameToImageSupplier supplier) {
        return new MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Cache<RegionAndName, ? extends Image>>(){

            public Cache<RegionAndName, ? extends Image> get() {
                return supplier.get();
            }
        });
    }

    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.AMZN_LINUX).os64Bit(true);
    }

    protected TemplateOptions provideTemplateOptions(Injector injector, TemplateOptions options) {
        return ((EC2TemplateOptions)options.as(EC2TemplateOptions.class)).userData("#cloud-config\nrepo_upgrade: none\n".getBytes());
    }
}

