/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class AWSRunningInstanceToNodeMetadata
extends RunningInstanceToNodeMetadata {
    @Inject
    protected AWSRunningInstanceToNodeMetadata(Map<InstanceState, NodeState> instanceToNodeState, Map<String, Credentials> credentialStore, Supplier<Cache<RegionAndName, ? extends Image>> imageMap, @Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Hardware>> hardware) {
        super(instanceToNodeState, credentialStore, imageMap, locations, hardware);
    }

    protected void addCredentialsForInstance(NodeMetadataBuilder builder, RunningInstance instance) {
        Credentials creds = (Credentials)this.credentialStore.get("node#" + instance.getRegion() + "/" + instance.getId());
        String spotRequestId = ((AWSRunningInstance)((Object)AWSRunningInstance.class.cast(instance))).getSpotInstanceRequestId();
        if (creds == null && spotRequestId != null && (creds = (Credentials)this.credentialStore.get("node#" + instance.getRegion() + "/" + spotRequestId)) != null) {
            this.credentialStore.put("node#" + instance.getRegion() + "/" + instance.getId(), creds);
        }
        if (creds != null) {
            builder.credentials(creds);
        }
    }

    protected NodeMetadataBuilder buildInstance(RunningInstance instance, NodeMetadataBuilder builder) {
        Map<String, String> tags = ((AWSRunningInstance)((Object)AWSRunningInstance.class.cast(instance))).getTags();
        return super.buildInstance(instance, builder).name(tags.get("Name")).tags(Maps.filterValues(tags, (Predicate)Predicates.equalTo((Object)"")).keySet()).userMetadata(Maps.filterValues(tags, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)""))));
    }
}

