/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.config.ClusterCompute;
import org.jclouds.aws.ec2.compute.suppliers.CallForImages;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class AWSRegionAndNameToImageSupplier
implements Supplier<Cache<RegionAndName, ? extends Image>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CacheLoader<RegionAndName, Image> regionAndIdToImage;
    private final Set<String> clusterComputeIds;
    private final CallForImages.Factory factory;
    private final ExecutorService executor;
    private final Iterable<String> regions;
    private final String amiQuery;
    private final Iterable<String> clusterRegions;
    private final String ccAmiQuery;

    @Inject
    protected AWSRegionAndNameToImageSupplier(@Region Set<String> regions, @Named(value="jclouds.ec2.ami-query") String amiQuery, @Named(value="jclouds.ec2.cc-regions") String clusterRegions, @Named(value="jclouds.ec2.cc-ami-query") String ccAmiQuery, CacheLoader<RegionAndName, Image> regionAndIdToImage, CallForImages.Factory factory, @ClusterCompute Set<String> clusterComputeIds, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.factory = factory;
        this.regions = regions;
        this.amiQuery = amiQuery;
        this.clusterRegions = Splitter.on((char)',').split((CharSequence)clusterRegions);
        this.ccAmiQuery = ccAmiQuery;
        this.regionAndIdToImage = regionAndIdToImage;
        this.clusterComputeIds = clusterComputeIds;
        this.executor = executor;
    }

    public Cache<RegionAndName, ? extends Image> get() {
        ImmutableSet parsedImages;
        ImmutableSet clusterImages;
        Future<Iterable<Image>> normalImages = this.images(this.regions, this.amiQuery, "jclouds.ec2.ami-query");
        try {
            clusterImages = ImmutableSet.copyOf(this.images(this.clusterRegions, this.ccAmiQuery, "jclouds.ec2.cc-ami-query").get());
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Error parsing images in query %s", new Object[]{this.ccAmiQuery});
            Throwables.propagate((Throwable)e);
            return null;
        }
        Iterables.addAll(this.clusterComputeIds, (Iterable)Iterables.transform((Iterable)clusterImages, (Function)new Function<Image, String>(){

            public String apply(Image arg0) {
                return arg0.getId();
            }
        }));
        try {
            parsedImages = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)clusterImages, normalImages.get()));
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Error parsing images in query %s", new Object[]{this.amiQuery});
            Throwables.propagate((Throwable)e);
            return null;
        }
        Cache cache = CacheBuilder.newBuilder().build(this.regionAndIdToImage);
        cache.asMap().putAll(Maps.uniqueIndex((Iterable)parsedImages, (Function)new Function<Image, RegionAndName>(){

            public RegionAndName apply(Image from) {
                return new RegionAndName(from.getLocation().getId(), from.getProviderId());
            }
        }));
        this.logger.debug("<< images(%d)", new Object[]{cache.asMap().size()});
        return cache;
    }

    private Future<Iterable<Image>> images(Iterable<String> regions, String query, String tag) {
        if (query.equals("")) {
            this.logger.debug(">> no %s specified, skipping image parsing", new Object[]{tag});
            return Futures.immediateFuture((Object)ImmutableSet.of());
        }
        return this.executor.submit(this.factory.parseImagesFromRegionsUsingFilter(regions, QueryStringToMultimap.INSTANCE.apply(query)));
    }

    public static enum QueryStringToMultimap implements Function<String, Multimap<String, String>>
    {
        INSTANCE;


        public Multimap<String, String> apply(String arg0) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (String pair : Splitter.on((char)';').split((CharSequence)arg0)) {
                String[] keyValue = pair.split("=");
                if (keyValue.length == 1) {
                    builder.putAll((Object)keyValue[0], (Iterable)ImmutableSet.of());
                    continue;
                }
                builder.putAll((Object)keyValue[0], Splitter.on((char)',').split((CharSequence)keyValue[1]));
            }
            return builder.build();
        }
    }
}

