/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindLaunchSpecificationToFormParams
implements Binder,
Function<LaunchSpecification, Map<String, String>> {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof LaunchSpecification), (Object)"this binder is only valid for LaunchSpecifications!");
        LaunchSpecification launchSpec = (LaunchSpecification)LaunchSpecification.class.cast(input);
        return (R)request.toBuilder().replaceFormParams((Multimap)Multimaps.forMap(this.apply(launchSpec))).build();
    }

    public Map<String, String> apply(LaunchSpecification launchSpec) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"LaunchSpecification.ImageId", Preconditions.checkNotNull((Object)launchSpec.getImageId(), (Object)"imageId"));
        if (launchSpec.getAvailabilityZone() != null) {
            builder.put((Object)"LaunchSpecification.Placement.AvailabilityZone", (Object)launchSpec.getAvailabilityZone());
        }
        AWSRunInstancesOptions options = new AWSRunInstancesOptions();
        if (launchSpec.getBlockDeviceMappings().size() > 0) {
            options.withBlockDeviceMappings((Set)launchSpec.getBlockDeviceMappings());
        }
        if (launchSpec.getSecurityGroupNames().size() > 0) {
            options.withSecurityGroups(launchSpec.getSecurityGroupNames());
        }
        if (launchSpec.getSecurityGroupIds().size() > 0) {
            options.withSecurityGroupIds(launchSpec.getSecurityGroupIds());
        }
        options.asType((String)Preconditions.checkNotNull((Object)launchSpec.getInstanceType(), (Object)"instanceType"));
        if (launchSpec.getKernelId() != null) {
            options.withKernelId(launchSpec.getKernelId());
        }
        if (launchSpec.getKeyName() != null) {
            options.withKeyName(launchSpec.getKeyName());
        }
        if (launchSpec.getRamdiskId() != null) {
            options.withRamdisk(launchSpec.getRamdiskId());
        }
        if (Boolean.TRUE.equals(launchSpec.isMonitoringEnabled())) {
            options.enableMonitoring();
        }
        if (launchSpec.getUserData() != null) {
            options.withUserData(launchSpec.getUserData());
        }
        for (Map.Entry entry : options.buildFormParameters().entries()) {
            builder.put((Object)("LaunchSpecification." + (String)entry.getKey()), entry.getValue());
        }
        return builder.build();
    }
}

