/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2AsyncClient;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.compute.predicates.AWSEC2InstancePresent;
import org.jclouds.aws.ec2.compute.strategy.CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.aws.ec2.options.RequestSpotInstancesOptions;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.predicates.InstancePresent;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.compute.strategy.EC2CreateNodesInGroupThenAddToSet;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class AWSEC2CreateNodesInGroupThenAddToSet
extends EC2CreateNodesInGroupThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    final AWSEC2Client client;
    final SpotInstanceRequestToAWSRunningInstance spotConverter;
    final AWSEC2AsyncClient aclient;
    final boolean generateInstanceNames;

    @Inject
    protected AWSEC2CreateNodesInGroupThenAddToSet(AWSEC2Client client, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, AWSEC2AsyncClient aclient, @Named(value="jclouds.ec2.generate-instance-names") boolean generateInstanceNames, Provider<TemplateBuilder> templateBuilderProvider, CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, AWSEC2InstancePresent instancePresent, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, LoadingCache<RunningInstance, LoginCredentials> instanceToCredentials, Map<String, Credentials> credentialStore, ComputeUtils utils, SpotInstanceRequestToAWSRunningInstance spotConverter) {
        super((EC2Client)client, elasticIpCache, nodeRunning, templateBuilderProvider, (CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions)createKeyPairAndSecurityGroupsAsNeededAndReturncustomize, (InstancePresent)instancePresent, runningInstanceToNodeMetadata, instanceToCredentials, credentialStore, utils);
        this.client = (AWSEC2Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.aclient = (AWSEC2AsyncClient)Preconditions.checkNotNull((Object)aclient, (Object)"aclient");
        this.spotConverter = (SpotInstanceRequestToAWSRunningInstance)Preconditions.checkNotNull((Object)spotConverter, (Object)"spotConverter");
        this.generateInstanceNames = generateInstanceNames;
    }

    protected Iterable<? extends RunningInstance> createNodesInRegionAndZone(String region, String zone, String group, int count, Template template, RunInstancesOptions instanceOptions) {
        Map tags = ComputeServiceUtils.metadataAndTagsAsValuesOfEmptyString((TemplateOptions)template.getOptions());
        Float spotPrice = this.getSpotPriceOrNull(template.getOptions());
        if (spotPrice != null) {
            LaunchSpecification spec = ((AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(instanceOptions))).getLaunchSpecificationBuilder().imageId(template.getImage().getProviderId()).availabilityZone(zone).build();
            RequestSpotInstancesOptions options = ((AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(template.getOptions())).getSpotOptions();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">> requesting %d spot instances region(%s) price(%f) spec(%s) options(%s)", new Object[]{count, region, spotPrice, spec, options});
            }
            return this.addTagsToInstancesInRegion(tags, Iterables.transform(this.client.getSpotInstanceServices().requestSpotInstancesInRegion(region, spotPrice.floatValue(), count, spec, options), (Function)this.spotConverter), region, group);
        }
        return this.addTagsToInstancesInRegion(tags, super.createNodesInRegionAndZone(region, zone, group, count, template, instanceOptions), region, group);
    }

    public Iterable<? extends RunningInstance> addTagsToInstancesInRegion(Map<String, String> metadata, Iterable<? extends RunningInstance> iterable, String region, String group) {
        if (metadata.size() > 0 || this.generateInstanceNames) {
            for (String id : Iterables.transform(iterable, (Function)new Function<RunningInstance, String>(){

                public String apply(RunningInstance arg0) {
                    return arg0.getId();
                }
            })) {
                this.aclient.getTagServices().createTagsInRegion(region, (Iterable<String>)ImmutableSet.of((Object)id), this.metadataForId(id, group, metadata));
            }
        }
        return iterable;
    }

    private Map<String, String> metadataForId(String id, String group, Map<String, String> metadata) {
        return this.generateInstanceNames && !metadata.containsKey("Name") ? ImmutableMap.builder().putAll(metadata).put((Object)"Name", (Object)id.replaceAll(".*-", group + "-")).build() : metadata;
    }

    private Float getSpotPriceOrNull(TemplateOptions options) {
        return options instanceof AWSEC2TemplateOptions ? ((AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options)).getSpotPrice() : null;
    }
}

