/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.aws.ec2.AWSEC2AsyncClient;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.compute.AWSEC2ComputeServiceContext;
import org.jclouds.aws.ec2.compute.config.AWSEC2ComputeServiceContextModule;
import org.jclouds.aws.ec2.config.AWSEC2RestClientModule;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.compute.config.EC2ResolveImagesModule;
import org.jclouds.rest.RestContext;

public class AWSEC2ApiMetadata
extends EC2ApiMetadata {
    private static final long serialVersionUID = -1492951757032303845L;
    public static final TypeToken<RestContext<AWSEC2Client, AWSEC2AsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<AWSEC2Client, AWSEC2AsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    private static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AWSEC2ApiMetadata.builder().fromApiMetadata((ApiMetadata)this);
    }

    public AWSEC2ApiMetadata() {
        this(AWSEC2ApiMetadata.builder());
    }

    protected AWSEC2ApiMetadata(Builder builder) {
        super((EC2ApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = EC2ApiMetadata.defaultProperties();
        properties.remove("jclouds.ec2.ami-owners");
        properties.setProperty("jclouds.ssh.max-retries", "7");
        properties.setProperty("jclouds.ssh.retry-auth", "true");
        properties.setProperty("jclouds.ec2.generate-instance-names", "true");
        return properties;
    }

    public static class Builder
    extends EC2ApiMetadata.Builder {
        protected Builder() {
            super(AWSEC2Client.class, AWSEC2AsyncClient.class);
            this.id("aws-ec2").version("2012-06-01").name("Amazon-specific EC2 API").view(AWSEC2ComputeServiceContext.class).context(CONTEXT_TOKEN).defaultProperties(AWSEC2ApiMetadata.defaultProperties()).defaultModules((Set)ImmutableSet.of(AWSEC2RestClientModule.class, EC2ResolveImagesModule.class, AWSEC2ComputeServiceContextModule.class));
        }

        public AWSEC2ApiMetadata build() {
            return new AWSEC2ApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

