/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.ec2.xml.ProductCodesHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindProductCodesToIndexedFormParams;
import org.jclouds.ec2.services.AMIAsyncClient;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface AWSAMIAsyncClient
extends AMIAsyncClient {
    @Named(value="ec2:DescribeImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeImageAttribute", "productCodes"})
    @XMLResponseParser(value=ProductCodesHandler.class)
    public ListenableFuture<Set<String>> getProductCodesForImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="ImageId") String var2);

    @Named(value="ec2:ModifyImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifyImageAttribute", "add", "productCodes"})
    public ListenableFuture<Void> addProductCodesToImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindProductCodesToIndexedFormParams.class) Iterable<String> var2, @FormParam(value="ImageId") String var3);

    @Named(value="ec2:ModifyImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifyImageAttribute", "remove", "productCodes"})
    public ListenableFuture<Void> removeProductCodesFromImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindProductCodesToIndexedFormParams.class) Iterable<String> var2, @FormParam(value="ImageId") String var3);
}

