/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.domain.MonitoringState;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.SinceApiVersion;

public class AWSRunningInstance
extends RunningInstance {
    private final MonitoringState monitoringState;
    @Nullable
    private final String placementGroup;
    private final Set<String> productCodes;
    @Nullable
    private final String subnetId;
    @Nullable
    private final String spotInstanceRequestId;
    @Nullable
    private final String vpcId;
    private final Hypervisor hypervisor;
    private final Map<String, String> securityGroupIdToNames;
    private final Map<String, String> tags;
    private final Optional<IAMInstanceProfile> iamInstanceProfile;

    public static Builder builder() {
        return new Builder();
    }

    protected AWSRunningInstance(String region, Map<String, String> securityGroupIdToNames, String amiLaunchIndex, String dnsName, String imageId, String instanceId, InstanceState instanceState, String rawState, String instanceType, String ipAddress, String kernelId, String keyName, Date launchTime, String availabilityZone, String virtualizationType, String platform, String privateDnsName, String privateIpAddress, String ramdiskId, String reason, RootDeviceType rootDeviceType, String rootDeviceName, Map<String, BlockDevice> ebsBlockDevices, MonitoringState monitoringState, String placementGroup, Iterable<String> productCodes, String subnetId, String spotInstanceRequestId, String vpcId, Hypervisor hypervisor, Map<String, String> tags, Optional<IAMInstanceProfile> iamInstanceProfile) {
        super(region, securityGroupIdToNames.values(), amiLaunchIndex, dnsName, imageId, instanceId, instanceState, rawState, instanceType, ipAddress, kernelId, keyName, launchTime, availabilityZone, virtualizationType, platform, privateDnsName, privateIpAddress, ramdiskId, reason, rootDeviceType, rootDeviceName, ebsBlockDevices);
        this.monitoringState = (MonitoringState)((Object)Preconditions.checkNotNull((Object)((Object)monitoringState), (Object)"monitoringState"));
        this.placementGroup = placementGroup;
        this.productCodes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(productCodes, (Object)"productCodes")));
        this.subnetId = subnetId;
        this.spotInstanceRequestId = spotInstanceRequestId;
        this.vpcId = vpcId;
        this.hypervisor = (Hypervisor)Preconditions.checkNotNull((Object)hypervisor, (Object)"hypervisor");
        this.securityGroupIdToNames = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(securityGroupIdToNames, (Object)"securityGroupIdToNames")));
        this.tags = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(tags, (Object)"tags")));
        this.iamInstanceProfile = (Optional)Preconditions.checkNotNull(iamInstanceProfile, (String)"iamInstanceProfile of %s", (Object[])new Object[]{instanceId});
    }

    public Map<String, String> getSecurityGroupIdToNames() {
        return this.securityGroupIdToNames;
    }

    public MonitoringState getMonitoringState() {
        return this.monitoringState;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public Set<String> getProductCodes() {
        return this.productCodes;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Hypervisor getHypervisor() {
        return this.hypervisor;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    @SinceApiVersion(value="2012-06-01")
    public Optional<IAMInstanceProfile> getIAMInstanceProfile() {
        return this.iamInstanceProfile;
    }

    protected Objects.ToStringHelper string() {
        return super.string().add("monitoringState", (Object)this.monitoringState).add("placementGroup", (Object)this.placementGroup).add("subnetId", (Object)this.subnetId).add("spotInstanceRequestId", (Object)this.spotInstanceRequestId).add("vpcId", (Object)this.vpcId).add("hypervisor", (Object)this.hypervisor).add("tags", this.tags).add("iamInstanceProfile", this.iamInstanceProfile.orNull());
    }

    public static class IAMInstanceProfile {
        private final String arn;
        private final String id;

        public static IAMInstanceProfile forArnAndId(String arn, String id) {
            return new IAMInstanceProfile(arn, id);
        }

        private IAMInstanceProfile(String arn, String id) {
            this.arn = (String)Preconditions.checkNotNull((Object)arn, (Object)"arn");
            this.id = (String)Preconditions.checkNotNull((Object)id, (String)"id for %s", (Object[])new Object[]{arn});
        }

        public String getArn() {
            return this.arn;
        }

        public String getId() {
            return this.id;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.arn, this.id});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IAMInstanceProfile that = (IAMInstanceProfile)IAMInstanceProfile.class.cast(obj);
            return Objects.equal((Object)this.arn, (Object)that.arn) && Objects.equal((Object)this.id, (Object)that.id);
        }

        public String toString() {
            return Objects.toStringHelper((String)"").add("arn", (Object)this.arn).add("id", (Object)this.id).toString();
        }
    }

    public static class Builder
    extends RunningInstance.Builder {
        private MonitoringState monitoringState;
        private String placementGroup;
        private Set<String> productCodes = Sets.newLinkedHashSet();
        private String subnetId;
        private String spotInstanceRequestId;
        private String vpcId;
        private Hypervisor hypervisor;
        private Map<String, String> securityGroupIdToNames = Maps.newLinkedHashMap();
        private Map<String, String> tags = Maps.newLinkedHashMap();
        private String iamInstanceProfileArn;
        private String iamInstanceProfileId;

        public Builder tags(Map<String, String> tags) {
            this.tags = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public Builder tag(String key, String value) {
            if (key != null) {
                this.tags.put(key, Strings.nullToEmpty((String)value));
            }
            return this;
        }

        public Builder securityGroupIdToNames(Map<String, String> securityGroupIdToNames) {
            this.securityGroupIdToNames = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(securityGroupIdToNames, (Object)"securityGroupIdToNames")));
            return this;
        }

        public Builder securityGroupIdToName(String key, String value) {
            if (key != null && value != null) {
                this.securityGroupIdToNames.put(key, value);
            }
            return this;
        }

        public Builder monitoringState(MonitoringState monitoringState) {
            this.monitoringState = monitoringState;
            return this;
        }

        public Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder productCodes(Iterable<String> productCodes) {
            this.productCodes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(productCodes, (Object)"productCodes")));
            return this;
        }

        public Builder productCode(String productCode) {
            if (productCode != null) {
                this.productCodes.add(productCode);
            }
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Builder hypervisor(Hypervisor hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public Builder iamInstanceProfileId(String iamInstanceProfileId) {
            this.iamInstanceProfileId = iamInstanceProfileId;
            return this;
        }

        public Builder amiLaunchIndex(String amiLaunchIndex) {
            return (Builder)((Object)Builder.class.cast(super.amiLaunchIndex(amiLaunchIndex)));
        }

        public Builder availabilityZone(String availabilityZone) {
            return (Builder)((Object)Builder.class.cast(super.availabilityZone(availabilityZone)));
        }

        public Builder devices(Map<String, BlockDevice> ebsBlockDevices) {
            return (Builder)((Object)Builder.class.cast(super.devices(ebsBlockDevices)));
        }

        public Builder dnsName(String dnsName) {
            return (Builder)((Object)Builder.class.cast(super.dnsName(dnsName)));
        }

        public Builder imageId(String imageId) {
            return (Builder)((Object)Builder.class.cast(super.imageId(imageId)));
        }

        public Builder instanceId(String instanceId) {
            return (Builder)((Object)Builder.class.cast(super.instanceId(instanceId)));
        }

        public Builder instanceState(InstanceState instanceState) {
            return (Builder)((Object)Builder.class.cast(super.instanceState(instanceState)));
        }

        public Builder rawState(String rawState) {
            return (Builder)((Object)Builder.class.cast(super.rawState(rawState)));
        }

        public Builder instanceType(String instanceType) {
            return (Builder)((Object)Builder.class.cast(super.instanceType(instanceType)));
        }

        public Builder ipAddress(String ipAddress) {
            return (Builder)((Object)Builder.class.cast(super.ipAddress(ipAddress)));
        }

        public Builder kernelId(String kernelId) {
            return (Builder)((Object)Builder.class.cast(super.kernelId(kernelId)));
        }

        public Builder keyName(String keyName) {
            return (Builder)((Object)Builder.class.cast(super.keyName(keyName)));
        }

        public Builder launchTime(Date launchTime) {
            return (Builder)((Object)Builder.class.cast(super.launchTime(launchTime)));
        }

        public Builder platform(String platform) {
            return (Builder)((Object)Builder.class.cast(super.platform(platform)));
        }

        public Builder privateDnsName(String privateDnsName) {
            return (Builder)((Object)Builder.class.cast(super.privateDnsName(privateDnsName)));
        }

        public Builder privateIpAddress(String privateIpAddress) {
            return (Builder)((Object)Builder.class.cast(super.privateIpAddress(privateIpAddress)));
        }

        public Builder ramdiskId(String ramdiskId) {
            return (Builder)((Object)Builder.class.cast(super.ramdiskId(ramdiskId)));
        }

        public Builder reason(String reason) {
            return (Builder)((Object)Builder.class.cast(super.reason(reason)));
        }

        public Builder region(String region) {
            return (Builder)((Object)Builder.class.cast(super.region(region)));
        }

        public Builder rootDeviceName(String rootDeviceName) {
            return (Builder)((Object)Builder.class.cast(super.rootDeviceName(rootDeviceName)));
        }

        public Builder rootDeviceType(RootDeviceType rootDeviceType) {
            return (Builder)((Object)Builder.class.cast(super.rootDeviceType(rootDeviceType)));
        }

        public Builder virtualizationType(String virtualizationType) {
            return (Builder)((Object)Builder.class.cast(super.virtualizationType(virtualizationType)));
        }

        public Builder device(String key, BlockDevice value) {
            return (Builder)((Object)Builder.class.cast(super.device(key, value)));
        }

        public Builder groupName(String groupName) {
            return (Builder)((Object)Builder.class.cast(super.groupName(groupName)));
        }

        public Builder groupNames(Iterable<String> groupNames) {
            return (Builder)((Object)Builder.class.cast(super.groupNames(groupNames)));
        }

        public AWSRunningInstance build() {
            Optional iamInstanceProfile = Optional.absent();
            if (this.iamInstanceProfileArn != null && this.iamInstanceProfileId != null) {
                iamInstanceProfile = Optional.of((Object)IAMInstanceProfile.forArnAndId(this.iamInstanceProfileArn, this.iamInstanceProfileId));
            }
            return new AWSRunningInstance(this.region, this.securityGroupIdToNames, this.amiLaunchIndex, this.dnsName, this.imageId, this.instanceId, this.instanceState, this.rawState, this.instanceType, this.ipAddress, this.kernelId, this.keyName, this.launchTime, this.availabilityZone, this.virtualizationType, this.platform, this.privateDnsName, this.privateIpAddress, this.ramdiskId, this.reason, this.rootDeviceType, this.rootDeviceName, this.ebsBlockDevices, this.monitoringState, this.placementGroup, this.productCodes, this.subnetId, this.spotInstanceRequestId, this.vpcId, this.hypervisor, this.tags, (Optional<IAMInstanceProfile>)iamInstanceProfile);
        }
    }
}

