/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Client;
import org.jclouds.aws.ec2.domain.AWSRunningInstance;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.PresentInstances;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class PresentSpotRequestsAndInstances
extends PresentInstances {
    private final AWSEC2Client client;
    private final Function<SpotInstanceRequest, AWSRunningInstance> spotConverter;

    @Inject
    public PresentSpotRequestsAndInstances(AWSEC2Client client, Function<SpotInstanceRequest, AWSRunningInstance> spotConverter) {
        super((EC2Client)client);
        this.client = (AWSEC2Client)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.spotConverter = (Function)Preconditions.checkNotNull(spotConverter, (Object)"spotConverter");
    }

    public Set<RunningInstance> apply(Set<RegionAndName> regionAndIds) {
        if (((Set)Preconditions.checkNotNull(regionAndIds, (Object)"regionAndIds")).isEmpty()) {
            return ImmutableSet.of();
        }
        if (Iterables.any(regionAndIds, (Predicate)Predicates.compose((Predicate)Predicates.containsPattern((String)"sir-"), (Function)RegionAndName.nameFunction()))) {
            return this.getSpots(regionAndIds);
        }
        return super.apply(regionAndIds);
    }

    protected Set<RunningInstance> getSpots(Set<RegionAndName> regionAndIds) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ListMultimap regionToSpotIds = Multimaps.transformValues((ListMultimap)Multimaps.index(regionAndIds, (Function)RegionAndName.regionFunction()), (Function)RegionAndName.nameFunction());
        for (Map.Entry entry : regionToSpotIds.asMap().entrySet()) {
            String region = (String)entry.getKey();
            Collection spotIds = (Collection)entry.getValue();
            this.logger.trace("looking for spots %s in region %s", new Object[]{spotIds, region});
            builder.addAll(Iterables.transform(this.client.getSpotInstanceServices().describeSpotInstanceRequestsInRegion(region, (String[])Iterables.toArray((Iterable)spotIds, String.class)), this.spotConverter));
        }
        return builder.build();
    }

    public String toString() {
        return "presentSpotRequestsAndInstances()";
    }
}

