/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.aws.ec2.domain.PlacementGroup;
import org.jclouds.aws.ec2.xml.DescribePlacementGroupsResponseHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface PlacementGroupAsyncClient {
    @Named(value="CreatePlacementGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreatePlacementGroup"})
    public ListenableFuture<Void> createPlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @FormParam(value="Strategy") String var3);

    @Named(value="CreatePlacementGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Strategy"}, values={"CreatePlacementGroup", "cluster"})
    public ListenableFuture<Void> createPlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2);

    @Named(value="DeletePlacementGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeletePlacementGroup"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deletePlacementGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2);

    @Named(value="DescribePlacementGroups")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribePlacementGroups"})
    @XMLResponseParser(value=DescribePlacementGroupsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<PlacementGroup>> describePlacementGroupsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);
}

