/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Provides;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.azure.storage.domain.BoundedSet;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.options.ListOptions;
import org.jclouds.azureblob.binders.BindAzureBlobMetadataToRequest;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.ContainerProperties;
import org.jclouds.azureblob.domain.ListBlobsResponse;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.azureblob.functions.BlobName;
import org.jclouds.azureblob.functions.ParseBlobFromHeadersAndHttpContent;
import org.jclouds.azureblob.functions.ParseBlobPropertiesFromHeaders;
import org.jclouds.azureblob.functions.ParseContainerPropertiesFromHeaders;
import org.jclouds.azureblob.functions.ParsePublicAccessHeader;
import org.jclouds.azureblob.functions.ReturnFalseIfContainerAlreadyExists;
import org.jclouds.azureblob.options.CreateContainerOptions;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.azureblob.predicates.validators.ContainerNameValidator;
import org.jclouds.azureblob.xml.AccountNameEnumerationResultsHandler;
import org.jclouds.azureblob.xml.ContainerNameEnumerationResultsHandler;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.blobstore.functions.ReturnFalseOnContainerNotFound;
import org.jclouds.blobstore.functions.ReturnFalseOnKeyNotFound;
import org.jclouds.blobstore.functions.ReturnNullOnContainerNotFound;
import org.jclouds.blobstore.functions.ReturnNullOnKeyNotFound;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.functions.ReturnTrueOn404;
import org.jclouds.http.options.GetOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@SkipEncoding(value={47})
@RequestFilters(value={SharedKeyLiteAuthentication.class})
@Headers(keys={"x-ms-version"}, values={"2009-09-19"})
@Path(value="/")
public interface AzureBlobAsyncClient {
    @Provides
    public AzureBlob newBlob();

    @GET
    @XMLResponseParser(value=AccountNameEnumerationResultsHandler.class)
    @QueryParams(keys={"comp"}, values={"list"})
    public ListenableFuture<? extends BoundedSet<ContainerProperties>> listContainers(ListOptions ... var1);

    @PUT
    @Path(value="{container}")
    @ExceptionParser(value=ReturnFalseIfContainerAlreadyExists.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public ListenableFuture<Boolean> createContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, CreateContainerOptions ... var2);

    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "acl"})
    @ResponseParser(value=ParsePublicAccessHeader.class)
    @ExceptionParser(value=ReturnNullOnContainerNotFound.class)
    public ListenableFuture<PublicAccess> getPublicAccessForContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype"}, values={"container"})
    @ResponseParser(value=ParseContainerPropertiesFromHeaders.class)
    @ExceptionParser(value=ReturnNullOnContainerNotFound.class)
    public ListenableFuture<ContainerProperties> getContainerProperties(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @HEAD
    @Path(value="{container}")
    @QueryParams(keys={"restype"}, values={"container"})
    @ExceptionParser(value=ReturnFalseOnContainerNotFound.class)
    public ListenableFuture<Boolean> containerExists(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @PUT
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "metadata"})
    public ListenableFuture<Void> setResourceMetadata(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @BinderParam(value=BindMapToHeadersWithPrefix.class) Map<String, String> var2);

    @DELETE
    @Path(value="{container}")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public ListenableFuture<Void> deleteContainer(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1);

    @PUT
    @Path(value="$root")
    @ExceptionParser(value=ReturnFalseIfContainerAlreadyExists.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public ListenableFuture<Boolean> createRootContainer(CreateContainerOptions ... var1);

    @DELETE
    @Path(value="$root")
    @ExceptionParser(value=ReturnTrueOn404.class)
    @QueryParams(keys={"restype"}, values={"container"})
    public ListenableFuture<Void> deleteRootContainer();

    @GET
    @XMLResponseParser(value=ContainerNameEnumerationResultsHandler.class)
    @Path(value="{container}")
    @QueryParams(keys={"restype", "comp"}, values={"container", "list"})
    public ListenableFuture<ListBlobsResponse> listBlobs(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, ListBlobsOptions ... var2);

    @GET
    @XMLResponseParser(value=ContainerNameEnumerationResultsHandler.class)
    @Path(value="$root")
    @QueryParams(keys={"restype", "comp"}, values={"container", "list"})
    public ListenableFuture<ListBlobsResponse> listBlobs(ListBlobsOptions ... var1);

    @PUT
    @Path(value="{container}/{name}")
    @ResponseParser(value=ParseETagHeader.class)
    public ListenableFuture<String> putBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") @ParamParser(value=BlobName.class) @BinderParam(value=BindAzureBlobMetadataToRequest.class) AzureBlob var2);

    @GET
    @ResponseParser(value=ParseBlobFromHeadersAndHttpContent.class)
    @ExceptionParser(value=ReturnNullOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public ListenableFuture<AzureBlob> getBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, GetOptions ... var3);

    @HEAD
    @ResponseParser(value=ParseBlobPropertiesFromHeaders.class)
    @ExceptionParser(value=ReturnNullOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public ListenableFuture<BlobProperties> getBlobProperties(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @HEAD
    @ExceptionParser(value=ReturnFalseOnKeyNotFound.class)
    @Path(value="{container}/{name}")
    public ListenableFuture<Boolean> blobExists(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);

    @PUT
    @Path(value="{container}/{name}")
    @QueryParams(keys={"comp"}, values={"metadata"})
    public ListenableFuture<Void> setBlobMetadata(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2, @BinderParam(value=BindMapToHeadersWithPrefix.class) Map<String, String> var3);

    @DELETE
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    @Path(value="{container}/{name}")
    public ListenableFuture<Void> deleteBlob(@PathParam(value="container") @ParamValidators(value={ContainerNameValidator.class}) String var1, @PathParam(value="name") String var2);
}

