/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.strategy.IfDirectoryReturnNameStrategy;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;

@Singleton
public class BlobPropertiesToBlobMetadata
implements Function<BlobProperties, MutableBlobMetadata> {
    private final IfDirectoryReturnNameStrategy ifDirectoryReturnName;
    private final Map<String, PublicAccess> containerAcls;

    @Inject
    public BlobPropertiesToBlobMetadata(IfDirectoryReturnNameStrategy ifDirectoryReturnName, Map<String, PublicAccess> containerAcls) {
        this.ifDirectoryReturnName = (IfDirectoryReturnNameStrategy)Preconditions.checkNotNull((Object)ifDirectoryReturnName, (Object)"ifDirectoryReturnName");
        this.containerAcls = (Map)Preconditions.checkNotNull(containerAcls, (Object)"containerAcls");
    }

    public MutableBlobMetadata apply(BlobProperties from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        to.setUserMetadata(from.getMetadata());
        to.setETag(from.getETag());
        to.setLastModified(from.getLastModified());
        to.setName(from.getName());
        to.setContainer(from.getContainer());
        to.setUri(from.getUrl());
        try {
            PublicAccess containerAcl = this.containerAcls.get(from.getContainer());
            if (containerAcl != null && containerAcl != PublicAccess.PRIVATE) {
                to.setPublicUri(from.getUrl());
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String directoryName = this.ifDirectoryReturnName.execute((StorageMetadata)to);
        if (directoryName != null) {
            to.setName(directoryName);
            to.setType((Enum)StorageType.RELATIVE_PATH);
        } else {
            to.setType((Enum)StorageType.BLOB);
        }
        return to;
    }
}

