/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.BlobType;
import org.jclouds.azureblob.domain.LeaseStatus;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.payloads.BaseImmutableContentMetadata;
import org.jclouds.javax.annotation.Nullable;

public class BlobPropertiesImpl
implements Serializable,
BlobProperties {
    private static final long serialVersionUID = -4648755473986695062L;
    private final BlobType type;
    private final String name;
    private final String container;
    private final URI url;
    private final Date lastModified;
    private final String eTag;
    private final Map<String, String> metadata = Maps.newLinkedHashMap();
    private final LeaseStatus leaseStatus;
    private final BaseImmutableContentMetadata contentMetadata;

    public BlobPropertiesImpl(BlobType type, String name, String container, URI url, Date lastModified, String eTag, long size, String contentType, @Nullable byte[] contentMD5, @Nullable String contentMetadata, @Nullable String contentLanguage, LeaseStatus leaseStatus, Map<String, String> metadata) {
        this.type = (BlobType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.leaseStatus = (LeaseStatus)((Object)Preconditions.checkNotNull((Object)((Object)leaseStatus), (Object)"leaseStatus"));
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.container = (String)Preconditions.checkNotNull((Object)container, (Object)"container");
        this.url = (URI)Preconditions.checkNotNull((Object)url, (Object)"url");
        this.lastModified = (Date)Preconditions.checkNotNull((Object)lastModified, (Object)"lastModified");
        this.eTag = (String)Preconditions.checkNotNull((Object)eTag, (Object)"eTag");
        this.contentMetadata = new BaseImmutableContentMetadata(contentType, Long.valueOf(size), contentMD5, null, contentLanguage, contentMetadata);
        this.metadata.putAll((Map)Preconditions.checkNotNull(metadata, (Object)"metadata"));
    }

    @Override
    public BlobType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public int compareTo(BlobProperties o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public URI getUrl() {
        return this.url;
    }

    @Override
    public LeaseStatus getLeaseStatus() {
        return this.leaseStatus;
    }

    @Override
    public ContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlobPropertiesImpl other = (BlobPropertiesImpl)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return String.format("[name=%s, container=%s, url=%s, contentMetadata=%s, eTag=%s, lastModified=%s, leaseStatus=%s, metadata=%s, type=%s]", new Object[]{this.name, this.container, this.url, this.contentMetadata, this.eTag, this.lastModified, this.leaseStatus, this.metadata, this.type});
    }
}

