/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.NameReplacingVisitor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.context.UsageTrackerKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.FunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0005\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/LiteralFunctionTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "fillCoroutineMetadata", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "Lorg/jetbrains/kotlin/descriptors/impl/ValueParameterDescriptorImpl$WithDestructuringDeclaration;", "js.translator"})
public final class LiteralFunctionTranslator
extends AbstractTranslator {
    @NotNull
    public final JsExpression translate(@NotNull KtDeclarationWithBody declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        PsiElement finalElement = UtilsKt.getFinalElement(declaration2);
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context()");
        TranslationContext invokingContext = translationContext;
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(invokingContext.bindingContext(), declaration2);
        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"getFunctionDescriptor(in\u2026ngContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        JsFunction jsFunction = invokingContext.getFunctionObject(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsFunction, (String)"invokingContext.getFunctionObject(descriptor)");
        JsFunction lambda2 = jsFunction;
        TranslationContext translationContext2 = invokingContext.newFunctionBodyWithUsageTracker(lambda2, descriptor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)translationContext2, (String)"invokingContext\n        \u2026acker(lambda, descriptor)");
        List<JsParameter> list2 = lambda2.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lambda.parameters");
        TranslationContext functionContext = FunctionTranslatorKt.translateAndAliasParameters(translationContext2, descriptor2, list2);
        List<ValueParameterDescriptor> list3 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"descriptor.valueParameters");
        Iterable $this$forEach$iv = list3;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            boolean bl = false;
            if (!(it instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration)) continue;
            JsBlock jsBlock = lambda2.getBody();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"lambda.body");
            jsBlock.getStatements().add(this.translate((ValueParameterDescriptorImpl.WithDestructuringDeclaration)it, functionContext));
        }
        JsBlock jsBlock = lambda2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"lambda.body");
        $this$forEach$iv = jsBlock.getStatements();
        List<JsStatement> list4 = FunctionBodyTranslator.setDefaultValueForArguments(descriptor2, functionContext);
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"setDefaultValueForArgume\u2026criptor, functionContext)");
        Object $i$f$forEach22 = list4;
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$forEach$iv, (Iterable)$i$f$forEach22);
        JsBlock jsBlock2 = lambda2.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock2, (String)"lambda.body");
        $this$forEach$iv = jsBlock2.getStatements();
        $i$f$forEach22 = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration2, functionContext);
        bl = false;
        $this$forEach$iv.add($i$f$forEach22);
        MetadataProperties.setFunctionDescriptor(lambda2, descriptor2);
        lambda2.setSource(finalElement);
        UsageTracker usageTracker = functionContext.usageTracker();
        if (usageTracker == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)usageTracker, (String)"functionContext.usageTracker()!!");
        UsageTracker tracker = usageTracker;
        JsName jsName = invokingContext.getInnerNameForDescriptor(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"invokingContext.getInner\u2026ForDescriptor(descriptor)");
        JsName name = jsName;
        if (UsageTrackerKt.hasCapturedExceptContaining(tracker)) {
            JsFunction jsFunction2 = TranslationUtils.simpleReturnFunction(invokingContext.scope(), lambda2.source(declaration2));
            Intrinsics.checkExpressionValueIsNotNull((Object)jsFunction2, (String)"simpleReturnFunction(inv\u2026mbda.source(declaration))");
            JsFunction lambdaCreator = jsFunction2;
            MetadataProperties.setLocal(lambdaCreator, true);
            if (tracker.getCapturedDescriptors().contains(descriptor2) && !DescriptorUtilsKt.isCoroutineLambda(descriptor2)) {
                lambda2.setName(UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor2));
            }
            MetadataProperties.setStaticRef(name, lambdaCreator);
            this.fillCoroutineMetadata(lambdaCreator, invokingContext, descriptor2);
            lambdaCreator.setSource(declaration2);
            return LiteralFunctionTranslatorKt.withCapturedParameters(lambdaCreator, functionContext, name, invokingContext, declaration2);
        }
        if (tracker.getCapturedDescriptors().contains(descriptor2)) {
            JsName jsName2 = UsageTrackerKt.getNameForCapturedDescriptor(tracker, descriptor2);
            if (jsName2 == null) {
                Intrinsics.throwNpe();
            }
            JsName capturedName = jsName2;
            JsName jsName3 = invokingContext.getInnerNameForDescriptor(descriptor2);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName3, (String)"invokingContext.getInner\u2026ForDescriptor(descriptor)");
            JsName globalName = jsName3;
            NameReplacingVisitor replacingVisitor = new NameReplacingVisitor(MapsKt.mapOf((Pair)TuplesKt.to((Object)capturedName, (Object)JsAstUtils.pureFqn(globalName, null))));
            replacingVisitor.accept((JsNode)lambda2);
        }
        MetadataProperties.setLocal(lambda2, true);
        LiteralFunctionTranslatorKt.access$addFunctionDeclaration(invokingContext, name, lambda2, declaration2);
        this.fillCoroutineMetadata(lambda2, invokingContext, descriptor2);
        MetadataProperties.setStaticRef(name, lambda2);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(name, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"JsAstUtils.pureFqn(name, null)");
        return jsNameRef;
    }

    public final void fillCoroutineMetadata(@NotNull JsFunction $this$fillCoroutineMetadata, @NotNull TranslationContext context, @NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fillCoroutineMetadata, (String)"$this$fillCoroutineMetadata");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (!descriptor2.isSuspend()) {
            return;
        }
        UtilsKt.fillCoroutineMetadata($this$fillCoroutineMetadata, context, descriptor2, descriptor2.getExtensionReceiverParameter() != null);
        MetadataProperties.setForceStateMachine($this$fillCoroutineMetadata, true);
    }

    @NotNull
    public final JsVars translate(@NotNull ValueParameterDescriptorImpl.WithDestructuringDeclaration $this$translate, @NotNull TranslationContext context) {
        ASTDelegatePsiElement aSTDelegatePsiElement;
        Intrinsics.checkParameterIsNotNull((Object)$this$translate, (String)"$this$translate");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($this$translate);
        if (!(psiElement instanceof KtParameter)) {
            psiElement = null;
        }
        if ((aSTDelegatePsiElement = (KtParameter)psiElement) == null || (aSTDelegatePsiElement = aSTDelegatePsiElement.getDestructuringDeclaration()) == null) {
            String string = "Destructuring declaration for descriptor " + $this$translate + " not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTDelegatePsiElement, (String)"(DescriptorToSourceUtils\u2026criptor $this not found\")");
        ASTDelegatePsiElement destructuringDeclaration = aSTDelegatePsiElement;
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference($this$translate, context);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"ReferenceTranslator.tran\u2026eReference(this, context)");
        JsExpression parameterRef = jsExpression;
        JsVars jsVars = DestructuringDeclarationTranslator.translate((KtDestructuringDeclaration)destructuringDeclaration, parameterRef, context);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsVars, (String)"DestructuringDeclaration\u2026n, parameterRef, context)");
        return jsVars;
    }

    public LiteralFunctionTranslator(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }
}

