/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.DeserializerForClassfileDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.psi.DeserializerForDecompilerBase;
import org.jetbrains.kotlin.analysis.decompiler.psi.LoggingErrorReporter;
import org.jetbrains.kotlin.analysis.decompiler.psi.ResolveEverythingToKotlinAnyLocalClassifierResolver;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedDataFinder;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.ContractDeserializerImpl;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.BinaryClassAnnotationAndConstantLoaderImpl;
import org.jetbrains.kotlin.load.kotlin.JavaFlexibleTypeDeserializer;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImpl;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/DeserializerForClassfileDecompiler;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/DeserializerForDecompilerBase;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "classFinder", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/DirectoryBasedClassFinder;", "deserializationComponents", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "resolveDeclarationsInFacade", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "facadeFqName", "Companion", "decompiler-to-psi"})
public final class DeserializerForClassfileDecompiler
extends DeserializerForDecompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DirectoryBasedClassFinder classFinder;
    @NotNull
    private final DeserializationComponents deserializationComponents;
    @NotNull
    private static final Logger LOG;

    public DeserializerForClassfileDecompiler(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkNotNullParameter((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        super(directoryPackageFqName);
        this.classFinder = new DirectoryBasedClassFinder(packageDirectory, directoryPackageFqName);
        DirectoryBasedDataFinder classDataFinder2 = new DirectoryBasedDataFinder(this.classFinder, LOG);
        NotFoundClasses notFoundClasses = new NotFoundClasses(this.getStorageManager(), this.getModuleDescriptor());
        BinaryClassAnnotationAndConstantLoaderImpl annotationAndConstantLoader = new BinaryClassAnnotationAndConstantLoaderImpl(this.getModuleDescriptor(), notFoundClasses, this.getStorageManager(), this.classFinder);
        DeserializationConfiguration configuration2 = new DeserializationConfiguration(){
            private final boolean readDeserializedContracts;
            private final boolean preserveDeclarationsOrdering;
            {
                this.readDeserializedContracts = true;
                this.preserveDeclarationsOrdering = true;
            }

            public boolean getReadDeserializedContracts() {
                return this.readDeserializedContracts;
            }

            public boolean getPreserveDeclarationsOrdering() {
                return this.preserveDeclarationsOrdering;
            }

            public boolean getAllowUnstableDependencies() {
                return DeserializationConfiguration.DefaultImpls.getAllowUnstableDependencies(this);
            }

            public boolean isJvmPackageNameSupported() {
                return DeserializationConfiguration.DefaultImpls.isJvmPackageNameSupported(this);
            }

            public boolean getReportErrorsOnPreReleaseDependencies() {
                return DeserializationConfiguration.DefaultImpls.getReportErrorsOnPreReleaseDependencies(this);
            }

            public boolean getSkipMetadataVersionCheck() {
                return DeserializationConfiguration.DefaultImpls.getSkipMetadataVersionCheck(this);
            }

            public boolean getSkipPrereleaseCheck() {
                return DeserializationConfiguration.DefaultImpls.getSkipPrereleaseCheck(this);
            }

            public boolean getTypeAliasesAllowed() {
                return DeserializationConfiguration.DefaultImpls.getTypeAliasesAllowed(this);
            }
        };
        this.deserializationComponents = new DeserializationComponents(this.getStorageManager(), this.getModuleDescriptor(), configuration2, classDataFinder2, annotationAndConstantLoader, this.getPackageFragmentProvider(), new ResolveEverythingToKotlinAnyLocalClassifierResolver(this.getBuiltIns()), new LoggingErrorReporter(LOG), LookupTracker.DO_NOTHING.INSTANCE, JavaFlexibleTypeDeserializer.INSTANCE, CollectionsKt.emptyList(), notFoundClasses, new ContractDeserializerImpl(configuration2, this.getStorageManager()), null, null, JvmProtoBufUtil.INSTANCE.getEXTENSION_REGISTRY(), null, new SamConversionResolverImpl(this.getStorageManager(), CollectionsKt.emptyList()), null, null, 876544, null);
    }

    @Override
    @NotNull
    protected KotlinBuiltIns getBuiltIns() {
        return DefaultBuiltIns.Companion.getInstance();
    }

    @Override
    @NotNull
    protected DeserializationComponents getDeserializationComponents() {
        return this.deserializationComponents;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DeclarationDescriptor> resolveDeclarationsInFacade(@NotNull FqName facadeFqName) {
        FqName fqName2;
        String[] strings2;
        KotlinClassHeader header;
        KotlinJvmBinaryClass binaryClassForPackageClass;
        Intrinsics.checkNotNullParameter((Object)facadeFqName, (String)"facadeFqName");
        FqName fqName3 = facadeFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"facadeFqName.parent()");
        FqName packageFqName = fqName3;
        boolean bl = Intrinsics.areEqual((Object)packageFqName, (Object)this.getDirectoryPackageFqName());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-DeserializerForClassfileDecompiler$resolveDeclarationsInFacade$22 = false;
            String $i$a$-assert-DeserializerForClassfileDecompiler$resolveDeclarationsInFacade$22 = "Was called for " + facadeFqName + "; only members of " + this.getDirectoryPackageFqName() + " package are expected.";
            throw new AssertionError((Object)$i$a$-assert-DeserializerForClassfileDecompiler$resolveDeclarationsInFacade$22);
        }
        KotlinClassFinder kotlinClassFinder = this.classFinder;
        ClassId classId = ClassId.topLevel(facadeFqName);
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(facadeFqName)");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = binaryClassForPackageClass = KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, classId);
        KotlinClassHeader kotlinClassHeader = header = kotlinJvmBinaryClass2 != null ? kotlinJvmBinaryClass2.getClassHeader() : null;
        String[] annotationData = kotlinClassHeader != null ? kotlinClassHeader.getData() : null;
        KotlinClassHeader kotlinClassHeader2 = header;
        Object object = strings2 = kotlinClassHeader2 != null ? kotlinClassHeader2.getStrings() : null;
        if (annotationData == null || strings2 == null) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass3 = binaryClassForPackageClass;
            LOG.error("Could not read annotation data for " + facadeFqName + " from " + (kotlinJvmBinaryClass3 != null ? kotlinJvmBinaryClass3.getClassId() : null));
            return CollectionsKt.emptyList();
        }
        Pair<JvmNameResolver, ProtoBuf.Package> pair = JvmProtoBufUtil.readPackageDataFrom(annotationData, strings2);
        JvmNameResolver nameResolver2 = (JvmNameResolver)pair.component1();
        ProtoBuf.Package packageProto = (ProtoBuf.Package)pair.component2();
        DeserializerForClassfileDecompiler deserializerForClassfileDecompiler = this;
        String string2 = header.getPackageName();
        if (string2 != null) {
            void p0;
            String string3 = string2;
            DeserializerForClassfileDecompiler deserializerForClassfileDecompiler2 = deserializerForClassfileDecompiler;
            boolean bl2 = false;
            fqName2 = new FqName((String)p0);
            deserializerForClassfileDecompiler = deserializerForClassfileDecompiler2;
        } else {
            FqName fqName4 = facadeFqName.parent();
            fqName2 = fqName4;
            Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"facadeFqName.parent()");
        }
        MutablePackageFragmentDescriptor dummyPackageFragment = deserializerForClassfileDecompiler.createDummyPackageFragment(fqName2);
        DeserializedPackageMemberScope membersScope2 = new DeserializedPackageMemberScope(dummyPackageFragment, packageProto, nameResolver2, header.getMetadataVersion(), new JvmPackagePartSource(binaryClassForPackageClass, packageProto, nameResolver2, null, false, null, 56, null), this.getDeserializationComponents(), "scope of dummyPackageFragment " + dummyPackageFragment.getFqName() + " in module " + this.getModuleDescriptor() + " @DeserializerForClassfileDecompiler", (Function0<? extends Collection<Name>>)((Function0)resolveDeclarationsInFacade.membersScope.1.INSTANCE));
        return CollectionsKt.toList((Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(membersScope2, null, null, 3, null));
    }

    static {
        Logger logger = Logger.getInstance(DeserializerForClassfileDecompiler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(Deserializer\u2026leDecompiler::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/DeserializerForClassfileDecompiler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "decompiler-to-psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

